/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.HealthComponent;
import com.supermicro.ipmi.HealthState;
import com.supermicro.ipmi.IPMIHealthCheckCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HealthCheckCommand
extends SuperBladeCommand {
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private Date checkAfterTime;
    private boolean checkPreInitTime;

    @Override
    public boolean preValidate() {
        String usage = "Usage: health [-p] [<Date> <Time>]\n\n-p: check pre-init time\nDate format: yyyy/MM/dd\nTime format: hh:mm:ss\n";
        if (this.parameters != null) {
            if (this.parameters.length == 1 && this.parameters[0].equals("-p")) {
                this.checkPreInitTime = true;
            } else if (this.parameters.length == 2) {
                try {
                    this.checkAfterTime = this.simpleDateFormat.parse(this.parameters[0] + " " + this.parameters[1]);
                }
                catch (ParseException e2) {
                    MOut.G(this).println("invalid date time format\n");
                    MOut.G(this).println(usage);
                    return false;
                }
            } else if (this.parameters.length == 3 && (this.parameters[0].equals("-p") || this.parameters[2].equals("-p"))) {
                try {
                    if (this.parameters[0].equals("-p")) {
                        this.checkAfterTime = this.simpleDateFormat.parse(this.parameters[1] + " " + this.parameters[2]);
                    } else if (this.parameters[2].equals("-p")) {
                        this.checkAfterTime = this.simpleDateFormat.parse(this.parameters[0] + " " + this.parameters[1]);
                    }
                    this.checkPreInitTime = true;
                }
                catch (ParseException e3) {
                    MOut.G(this).println("invalid date time format\n");
                    MOut.G(this).println(usage);
                    return false;
                }
            } else {
                MOut.G(this).println(usage);
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIHealthCheckCommand ipmiHealthCheckCommand = new IPMIHealthCheckCommand(null);
        ipmiHealthCheckCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiHealthCheckCommand.setProgress(new HealthProgress());
        ipmiHealthCheckCommand.healthCheck(this.checkAfterTime, this.checkPreInitTime);
        MOut.G(this).println("Check after " + this.simpleDateFormat.format(ipmiHealthCheckCommand.getCheckTime()));
        MOut.G(this).println("Check Pre-Init Time: " + ipmiHealthCheckCommand.isCheckPreInitTime());
        MOut.G(this).println("");
        String formatServer = " %-20s | %10s | %-40s \n";
        MOut.G(this).printf(formatServer, "Item", "State", "Message");
        MOut.G(this).printf(formatServer, "----", "-----", "-------");
        for (HealthComponent aHealthComponent : ipmiHealthCheckCommand.getHealthServer().getHealthComponentList()) {
            String msg = aHealthComponent.getMsg();
            Object[] objectArray = new Object[3];
            objectArray[0] = aHealthComponent.getName();
            objectArray[1] = HealthState.getStateString(aHealthComponent.getState());
            objectArray[2] = aHealthComponent.getState() == 1 ? (msg == null ? "" : msg) : "";
            MOut.G(this).printf(formatServer, objectArray);
        }
        this.statusCode = 0;
    }

    public class HealthProgress
    implements IPMIHealthCheckCommand.Progress {
        @Override
        public void setValue(int value) {
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                MOut.G().println(value + "%");
            }
        }

        @Override
        public void message(String message) {
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                MOut.G().println(message);
            }
        }

        @Override
        public void left(long value) {
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                MOut.G().println("left " + value + " ms");
            }
        }
    }
}

