/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.HostManager;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class Host
implements Comparable {
    public static final int HOST = 0;
    public static final int GROUP = 1;
    private String name;
    private String ip;
    private String username;
    private String password;
    private int cipherSuite;
    private int hostType;
    SortedSet subHosts = new TreeSet();

    public int compareTo(Object o) {
        return this.name.compareTo(((Host)o).getName());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCipherSuite(int cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public void setHostType(int hostType) {
        this.hostType = hostType;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getCipherSuite() {
        return this.cipherSuite;
    }

    public int getHostType() {
        return this.hostType;
    }

    public SortedSet getSubHosts() {
        return this.subHosts;
    }

    public void updateProperties() {
        if (this.hostType == 1) {
            HostManager.getInstance().setProperty("*" + this.name, this.toPropertiesTypeString());
        } else if (this.hostType == 0) {
            HostManager.getInstance().setProperty(this.name, this.toPropertiesTypeString());
        }
    }

    public void updateHostName(String newname) {
        HostManager.getInstance().removeProperty(this.hostType == 1 ? "*" + this.name : this.name);
        this.setName(newname);
        this.updateProperties();
    }

    public Host findSubHost(String hostname) {
        for (Host item : this.subHosts) {
            if (!item.getName().equals(hostname)) continue;
            return item;
        }
        return null;
    }

    public void addSubHost(Host host) {
        this.subHosts.add(host);
        HostManager.getInstance().removeProperty("*" + this.name);
        HostManager.getInstance().setProperty("*" + this.name, this.toPropertiesTypeString());
    }

    public boolean removeSubHostsByName(String hostname) {
        Host willRemove = null;
        for (Host item : this.subHosts) {
            if (!item.getName().equals(hostname)) continue;
            willRemove = item;
        }
        if (willRemove != null) {
            this.subHosts.remove(willRemove);
            HostManager.getInstance().removeProperty("*" + this.name);
            HostManager.getInstance().setProperty("*" + this.name, this.toPropertiesTypeString());
            return true;
        }
        return false;
    }

    public String toPropertiesTypeString() {
        String retStr = "";
        if (this.hostType == 1) {
            Iterator iter = this.subHosts.iterator();
            while (iter.hasNext()) {
                Host item = (Host)iter.next();
                retStr = retStr + item.getName();
                if (!iter.hasNext()) continue;
                retStr = retStr + ",";
            }
        } else if (this.hostType == 0) {
            retStr = this.username == null ? this.ip : this.ip + "," + this.username + "," + this.password;
        }
        return retStr;
    }

    public String toString() {
        if (this.hostType == 0) {
            if (this.username == null) {
                return String.format("\t%-20s %-20s", this.name, "(" + this.ip + ")");
            }
            return String.format("\t%-20s %-20s", this.name, "(" + this.ip + "," + this.username + "," + this.password + ")");
        }
        if (this.subHosts.size() == 0) {
            return String.format("\t%-20s %-20s", this.name, "(empty)");
        }
        StringBuffer sb = new StringBuffer();
        String hosts = "";
        boolean isFirst = true;
        Iterator iter = this.subHosts.iterator();
        while (iter.hasNext()) {
            Host item = (Host)iter.next();
            if (isFirst) {
                sb.append(String.format("\t%-20s %-20s", this.name, item.getName()));
                isFirst = false;
            } else {
                sb.append(String.format("\t%-20s %-20s", "", item.getName()));
            }
            if (!iter.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

