/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.RedfishFlashARM;
import java.io.File;
import java.time.Duration;
import java.time.Instant;

public class IPMIFlashARMCommand
extends SuperBladeCommand {
    private Instant timestampBegin;
    private boolean isUpdateSCP;

    @Override
    public boolean preValidate() {
        this.isUpdateSCP = false;
        if (this.parameters == null) {
            MOut.G(this).println("Firmware filename is needed");
            MOut.G(this).println("");
            MOut.G(this).println("Usage: ipmi flasharm <filename> [--scp]");
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        if (this.parameters.length > 1 && this.parameters[1].equals("--scp")) {
            this.isUpdateSCP = true;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.checkIfSystemLockdown()) {
            if (!this.isDeviceSupported()) {
                MOut.G(this).println("Not a supported device");
                this.statusCode = 153;
            } else {
                int imageType;
                this.printPrecautions();
                super.closeSessionIfExist();
                super.ignoreSessionClose(true);
                this.timeCounterStart(true);
                RedfishFlashARM utils = new RedfishFlashARM();
                int n = imageType = this.isUpdateSCP ? 2 : 0;
                if (utils.flash(this.config, this.parameters[0], imageType)) {
                    this.timeCounterStart(false);
                    this.statusCode = 0;
                } else {
                    this.statusCode = 149;
                }
            }
        }
    }

    private boolean isDeviceSupported() {
        IPMIInterface ipmiInterface = this.ipmiCMMOEMCommand.getIPMIInterface();
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(ipmiInterface);
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        return IPMIMessagingCommand.isR12OpenBMCGUID(guid) || IPMIMessagingCommand.isR12OpenBMCRoTGUID(guid) || IPMIMessagingCommand.isR13OpenBMCGUID(guid);
    }

    private void printPrecautions() {
        StringBuilder builder = new StringBuilder();
        builder.append("**************************************************************\n");
        builder.append("WARNING!\n");
        builder.append("Firmware upgrade must not be interrupted once it is started.\n");
        builder.append("Once you get error after Upgrading, please use local KCS tool\n");
        builder.append("for recovery.\n");
        builder.append("**************************************************************");
        MOut.G(this).println(builder.toString());
    }

    private void timeCounterStart(boolean start) {
        if (start) {
            this.timestampBegin = Instant.now();
        } else {
            Instant timestampEnd = Instant.now();
            long timeElapsed = Duration.between(this.timestampBegin, timestampEnd).toMillis() / 1000L;
            MOut.G(this).println("Total Elapsed Time: " + (timeElapsed > 60L ? timeElapsed / 60L + " min " : "") + timeElapsed % 60L + " sec(s)");
        }
    }
}

