/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.RedfishFlash;
import java.io.File;

public class IPMIFlashRedfishCommand
extends SuperBladeCommand {
    boolean preserveCFG = false;
    boolean preserveSDR = false;
    boolean preserveSSL = false;
    String backupImage = "false";

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Firmware filename is needed");
            MOut.G(this).println("");
            MOut.G(this).println("ipmi flashrf <filename> [Preserve_opt]");
            MOut.G(this).println("Preserve option");
            MOut.G(this).println("-cfg             Preserve Configuration");
            MOut.G(this).println("-sdr             Preserve SDR");
            MOut.G(this).println("-ssl             Preserve SSL certificate");
            MOut.G(this).println("-backup          Backup image (Rot only)");
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        String options = "";
        if (this.parameters.length > 1) {
            for (int i2 = 1; i2 < this.parameters.length; ++i2) {
                options = options + this.parameters[i2] + " ";
            }
            if (options.toLowerCase().indexOf("-cfg") != -1) {
                MOut.G(this).println("Option: preserve CFG");
                this.preserveCFG = true;
            }
            if (options.toLowerCase().indexOf("-sdr") != -1) {
                MOut.G(this).println("Option: preserve SDR");
                this.preserveSDR = true;
            }
            if (options.toLowerCase().indexOf("-ssl") != -1) {
                MOut.G(this).println("Option: preserve SSL");
                this.preserveSSL = true;
            }
            if (options.toLowerCase().indexOf("-backup") != -1) {
                MOut.G(this).println("Option: Backup image");
                this.backupImage = "true";
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        if (!this.checkIfSupportedDevice()) {
            MOut.G(this).println("Not a supported device");
            this.statusCode = 153;
            return;
        }
        MOut.G(this).println("**************************************************************");
        MOut.G(this).println("WARNING!");
        MOut.G(this).println("Firmware upgrade must not be interrupted once it is started.");
        MOut.G(this).println("Once you get error after Upgrading, please use local KCS tool");
        MOut.G(this).println("for recovery.");
        MOut.G(this).println("**************************************************************");
        String body = "{\"Targets\":[\"/redfish/v1/Managers/1\"],\r\n\"@Redfish.OperationApplyTime\":\"Immediate\",\r\n\"Oem\":{\"Supermicro\":{\"BMC\":{\"PreserveCfg\":" + this.preserveCFG + ",\r\n\"PreserveSdr\":" + this.preserveSDR + ",\r\n\"PreserveSsl\":" + this.preserveSSL + ",\r\n\"BackupBMC\":" + this.backupImage + "}}}}";
        this.sessionController.closeSession();
        RedfishFlash redfishFlash = new RedfishFlash();
        redfishFlash.setMOut(MOut.G(this));
        this.statusCode = redfishFlash.flash(this.config, this.parameters[0], body) ? 0 : 149;
        this.ignoreSessionClose(true);
    }

    public boolean checkIfSupportedDevice() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        return IPMIMessagingCommand.isX12GUID(guid) || IPMIMessagingCommand.isX12RoTGUID(guid) || IPMIMessagingCommand.isX12RoTHW2GUID(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isH13ROTMAC12GUID(guid) || IPMIMessagingCommand.isH13ROTMAC34GUID(guid) || IPMIMessagingCommand.isAST2600GUID(guid) || IPMIMessagingCommand.isAST2600HW1GUID(guid) || IPMIMessagingCommand.isAST2600NonRoTGUID(guid) || IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isB12AST2600GUID(guid) || IPMIMessagingCommand.isB13AST2600RoTGUID(guid) || IPMIMessagingCommand.isB14AST2600RoT20GUID(guid) || IPMIMessagingCommand.isB3SD1GUID(guid) || IPMIMessagingCommand.isB3ST1GUID(guid) || IPMIMessagingCommand.isB4SA1GUID(guid) || IPMIMessagingCommand.isX12DGOGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid) || IPMIMessagingCommand.isB12AST2600MAC1GUID(guid) || IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid) || IPMIMessagingCommand.isM12GUID(guid) || IPMIMessagingCommand.isH13GUID(guid) || IPMIMessagingCommand.isX12AST2600NonRoT(guid) || IPMIMessagingCommand.isX12AST2600NonRoTHW1(guid) || IPMIMessagingCommand.isX12DSCGUID(guid) || IPMIMessagingCommand.isX12DGQGUID(guid) || IPMIMessagingCommand.isH12DSGGUID(guid) || IPMIMessagingCommand.isHGIMEZZGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isX13ROTGUID(guid) || IPMIMessagingCommand.isX13ROTMAC1GUID(guid) || IPMIMessagingCommand.isX13ROTHW1GUID(guid) || IPMIMessagingCommand.isX13ROT8WAYSGUID(guid) || IPMIMessagingCommand.isX12SPTGUID(guid) || IPMIMessagingCommand.isX12DGUGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid) || IPMIMessagingCommand.isX13DeltaNextGUID(guid) || IPMIMessagingCommand.isH13DeltaNextGUID(guid) || IPMIMessagingCommand.isH13DeltaNextHW1GUID(guid) || IPMIMessagingCommand.isH13AST2600HW1Rot20GUID(guid) || IPMIMessagingCommand.isH13AST2600NonRoTGUID(guid) || IPMIMessagingCommand.isH13OpenBMCHW2GUID(guid) || IPMIMessagingCommand.isH14AST2600ROT20HW2GUID(guid) || IPMIMessagingCommand.isX13AST2600NonRoTGUID(guid) || IPMIMessagingCommand.isX13AST2600NonRoTHW1GUID(guid) || IPMIMessagingCommand.isX13AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isX13AST2600RoTSBBGUID(guid) || IPMIMessagingCommand.isG1AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isJBOF2600GUID(guid) || IPMIMessagingCommand.isX14AST2600ROT20HW1GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20HW2GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20GD3GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20DCMHSGUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20MAC1GUID(guid);
    }
}

