/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMIpv6Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanIPV6AutoConfigCommand
extends SuperBladeCommand {
    int mode;

    @Override
    public boolean preValidate() {
        this.mode = 99;
        if (this.parameters != null && this.parameters.length == 1) {
            try {
                this.mode = Integer.parseInt(this.parameters[0]);
            }
            catch (NumberFormatException e2) {
                MOut.G(this).println("Invalid parameters");
                MOut.G(this).println("Usage: ipmi lan ipv6 autoconfig [off:0|on:1]");
                return false;
            }
            if (this.mode != 0 && this.mode != 1) {
                MOut.G(this).println("Usage: ipmi lan ipv6 autoconfig [off:0|on:1]");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiLanCommand.getIPProtocol() == 0) {
            MOut.G(this).println("Current protocol is IPv4 only");
            this.statusCode = 156;
            return;
        }
        IPMIOEMIpv6Command ipmioemipv6Command = new IPMIOEMIpv6Command(null);
        ipmioemipv6Command.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.mode == 0 || this.mode == 1) {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            int dhcpMode = ipmioemipv6Command.getIPV6DHCPMode();
            if (ipmioemipv6Command.setIPV6Network(dhcpMode, this.mode != 0)) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Fail");
            this.statusCode = 149;
            return;
        }
        if (ipmioemipv6Command.isAutoConfig()) {
            MOut.G(this).println("Auto configuration is currently enabled");
        } else {
            MOut.G(this).println("Auto configuration is currently disabled");
        }
        this.statusCode = 0;
    }
}

