/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanIPV6ListCommand
extends SuperBladeCommand {
    String formatTemplate = "%5s | %-50s | %-6s \n";

    @Override
    public void runCommand() throws Exception {
        byte[] data;
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiLanCommand.getIPProtocol() == 0) {
            MOut.G(this).println("Current protocol is IPv4 only");
            this.statusCode = 156;
            return;
        }
        byte by = ipmiLanCommand.getMaxStaticIPv6Number();
        byte maxDynamic = ipmiLanCommand.getMaxDynamicIPv6Number();
        MOut.G(this).println("Maximum number of IPv6 static address: " + by);
        MOut.G(this).print(this.toFormatedHeader());
        StringBuffer formatedString = new StringBuffer();
        for (byte i2 = 0; i2 < by; i2 = (byte)(i2 + 1)) {
            data = ipmiLanCommand.getStaticIPv6Array(i2);
            formatedString.append(String.format(this.formatTemplate, i2, this.parseIP(data), this.parsePrefix(data)));
        }
        MOut.G(this).println(formatedString.toString());
        MOut.G(this).println("");
        MOut.G(this).println("Maximum number of IPv6 dynamic address: " + maxDynamic);
        MOut.G(this).print(this.toFormatedHeaderDynamic());
        formatedString = new StringBuffer();
        for (byte i2 = 0; i2 < maxDynamic; i2 = (byte)(i2 + 1)) {
            data = ipmiLanCommand.getDynamicIPv6Array(i2);
            if (this.parseIPDynamic(data).equals("Disabled")) continue;
            formatedString.append(String.format(this.formatTemplate, "", this.parseIPDynamic(data), this.parsePrefix(data)));
        }
        MOut.G(this).println(formatedString.toString());
        this.statusCode = 0;
    }

    public String toFormatedHeader() {
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(this.formatTemplate, "ID", "IPv6 Address", "Prefix"));
        formatedString.append(String.format(this.formatTemplate, "---", "------------", "------"));
        return formatedString.toString();
    }

    public String toFormatedHeaderDynamic() {
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(this.formatTemplate, "", "IPv6 Address", "Prefix"));
        formatedString.append(String.format(this.formatTemplate, "", "------------", "------"));
        return formatedString.toString();
    }

    public String parseIP(byte[] data) {
        if (data == null) {
            return "";
        }
        if (data.length > 2 && (data[2] & 0xFFFFFF80) != -128) {
            return "Disabled";
        }
        String ip = "";
        if (data.length > 18) {
            ip = ByteUtility.byteToHex(data[3]) + ByteUtility.byteToHex(data[4]) + ":" + ByteUtility.byteToHex(data[5]) + ByteUtility.byteToHex(data[6]) + ":" + ByteUtility.byteToHex(data[7]) + ByteUtility.byteToHex(data[8]) + ":" + ByteUtility.byteToHex(data[9]) + ByteUtility.byteToHex(data[10]) + ":" + ByteUtility.byteToHex(data[11]) + ByteUtility.byteToHex(data[12]) + ":" + ByteUtility.byteToHex(data[13]) + ByteUtility.byteToHex(data[14]) + ":" + ByteUtility.byteToHex(data[15]) + ByteUtility.byteToHex(data[16]) + ":" + ByteUtility.byteToHex(data[17]) + ByteUtility.byteToHex(data[18]);
        }
        return ip;
    }

    public String parseIPDynamic(byte[] data) {
        if (data == null) {
            return "";
        }
        if (data.length > 20 && data[20] != 0) {
            return "Disabled";
        }
        String ip = "";
        if (data.length > 18) {
            ip = ByteUtility.byteToHex(data[3]) + ByteUtility.byteToHex(data[4]) + ":" + ByteUtility.byteToHex(data[5]) + ByteUtility.byteToHex(data[6]) + ":" + ByteUtility.byteToHex(data[7]) + ByteUtility.byteToHex(data[8]) + ":" + ByteUtility.byteToHex(data[9]) + ByteUtility.byteToHex(data[10]) + ":" + ByteUtility.byteToHex(data[11]) + ByteUtility.byteToHex(data[12]) + ":" + ByteUtility.byteToHex(data[13]) + ByteUtility.byteToHex(data[14]) + ":" + ByteUtility.byteToHex(data[15]) + ByteUtility.byteToHex(data[16]) + ":" + ByteUtility.byteToHex(data[17]) + ByteUtility.byteToHex(data[18]);
        }
        return ip;
    }

    public int parsePrefix(byte[] data) {
        if (data != null && data.length > 19) {
            return data[19] & 0xFF;
        }
        return 0;
    }
}

