/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanIPV6RouteAddCommand
extends SuperBladeCommand {
    int id;
    int prefixLength;
    String prefixValue;
    String address;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && this.parameters.length == 4) {
            try {
                this.id = Integer.parseInt(this.parameters[0]);
            }
            catch (NumberFormatException e2) {
                this.printUsage();
                return false;
            }
            try {
                this.prefixLength = Integer.parseInt(this.parameters[1]);
            }
            catch (NumberFormatException e3) {
                this.printUsage();
                return false;
            }
            if (this.id != 1 && this.id != 2) {
                MOut.G(this).println("ID must be 1 or 2");
                this.printUsage();
                return false;
            }
            if (!StunnelUtility.isIPv6(this.parameters[3])) {
                MOut.G(this).println("Not a valid IPv6 address.");
                MOut.G(this).println("You may try standard IPv6 address format:");
                MOut.G(this).println("0000:0000:0000:0000:0000:0000:0000:0000");
                return false;
            }
            this.prefixValue = this.parameters[2];
            this.address = this.parameters[3];
            return true;
        }
        this.printUsage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiLanCommand.getIPProtocol() == 0) {
            MOut.G(this).println("Current protocol is IPv4 only");
            this.statusCode = 156;
            return;
        }
        if (!IPMILanCommand.isStandardIPv6Address(this.address)) {
            this.address = IPMILanCommand.StandardIPv6Converter(this.address);
        }
        ipmiLanCommand.setStaticRouterAddress(this.id, this.address);
        ipmiLanCommand.setStaticRouterPrefixLength(this.id, this.prefixLength);
        ipmiLanCommand.setStaticRouterPrefixValue(this.id, this.prefixValue);
        this.statusCode = 0;
    }

    public void printUsage() {
        MOut.G(this).println("Usage: ipmi lan ipv6 route add <ID> <prefix Length> <prefix value> <address>");
    }
}

