/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanIPV6RouteClearCommand
extends SuperBladeCommand {
    int id;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && this.parameters.length == 1) {
            try {
                this.id = Integer.parseInt(this.parameters[0]);
            }
            catch (NumberFormatException e2) {
                MOut.G(this).println("Invalid ID");
                return false;
            }
            if (this.id != 1 && this.id != 2) {
                MOut.G(this).println("ID must be 1 or 2");
                return false;
            }
        } else {
            MOut.G(this).println("Usage: ipmi lan ipv6 route clear <ID>");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        String clearValue = "0000:0000:0000:0000:0000:0000:0000:0000";
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiLanCommand.getIPProtocol() == 0) {
            MOut.G(this).println("Current protocol is IPv4 only");
            this.statusCode = 156;
            return;
        }
        ipmiLanCommand.setStaticRouterPrefixLength(this.id, 255);
        ipmiLanCommand.setStaticRouterPrefixValue(this.id, clearValue);
        ipmiLanCommand.setStaticRouterAddress(this.id, clearValue);
        this.statusCode = 0;
    }
}

