/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMHostNameCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanLinkStatus
extends SuperBladeCommand {
    private String hostname;
    private String macAddress;
    private String vlanMode;
    private String vlanID;
    private String lanInterface;
    private String rmcpPort;
    private String activedInterface;
    private String dedicatedLinkMode;
    private String dedicatedStatus;
    private String dedicatedSpeed;
    private String dedicatedDuplex;
    private String shareStatus;
    private String shareSpeed;
    private String shareDuplex;
    private int supportedMask;

    @Override
    public void runCommand() throws Exception {
        this.init();
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIAMIOEMCommand ipmiAMICommand = new IPMIAMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIOEMHostNameCommand ipmiOEMHostNameCommand = new IPMIOEMHostNameCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        this.setAttribute(() -> {
            this.supportedMask = this.getIntegerMask(this.getLANModeMask(ipmiAMICommand));
        });
        this.setAttribute(() -> {
            this.hostname = new String(ipmiOEMHostNameCommand.getHostName());
        });
        this.setAttribute(() -> {
            this.macAddress = ipmiLanCommand.getMAC();
        });
        this.setAttribute(() -> {
            this.vlanMode = ipmiLanCommand.isVLANEnabled() ? "ON" : "OFF";
        });
        this.setAttribute(() -> {
            this.vlanID = String.valueOf(ipmiLanCommand.getVLANTag());
        });
        this.setAttribute(() -> {
            this.rmcpPort = String.valueOf(this.getConfig().getPort());
        });
        this.setAttribute(() -> {
            this.dedicatedLinkMode = ipmiAMICommand.getDedicatedLinkMode();
        });
        this.setAttribute(() -> {
            this.dedicatedStatus = ipmiAMICommand.getDedicatedStatus();
        });
        this.setAttribute(() -> {
            this.dedicatedSpeed = ipmiAMICommand.getDedicatedSpeed();
        });
        this.setAttribute(() -> {
            this.dedicatedDuplex = ipmiAMICommand.getDedicatedDuplexMode();
        });
        this.setAttribute(() -> {
            this.shareStatus = ipmiAMICommand.getShareStatus();
        });
        this.setAttribute(() -> {
            this.shareSpeed = ipmiAMICommand.getShareSpeed();
        });
        this.setAttribute(() -> {
            this.shareDuplex = ipmiAMICommand.getShareDuplexMode();
        });
        this.setAttribute(() -> {
            this.lanInterface = IPMIAMIOEMCommand.getLanModeText(ipmiAMICommand.getLANMode());
        });
        this.setAttribute(() -> {
            byte[] status = ipmiAMICommand.getNetworkLinkStatus();
            if (null != status && status.length > 1) {
                switch (status[1]) {
                    case 0: {
                        this.activedInterface = "Dedicated";
                        break;
                    }
                    case 1: {
                        this.activedInterface = "Share";
                        break;
                    }
                    case 2: {
                        this.activedInterface = "Failover";
                        break;
                    }
                    default: {
                        this.activedInterface = "Unknown";
                    }
                }
            }
        });
        this.output();
        this.statusCode = 0;
    }

    private void init() {
        this.hostname = "";
        this.macAddress = "";
        this.vlanMode = "Unknown";
        this.vlanID = "Unknown";
        this.lanInterface = "Unknown";
        this.rmcpPort = "";
        this.activedInterface = "Unknown";
        this.dedicatedLinkMode = "Unknown";
        this.dedicatedStatus = "Disconnected";
        this.dedicatedSpeed = "Unknown";
        this.dedicatedDuplex = "Unknown";
        this.shareStatus = "Disconnected";
        this.shareSpeed = "Unknown";
        this.shareDuplex = "Unknown";
    }

    private void output() {
        String outputFormat = "%-20s : %-30s \n";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("General").append(System.lineSeparator());
        stringBuffer.append("-------").append(System.lineSeparator());
        stringBuffer.append(String.format("%-20s : %-30s \n", "Hostname", this.hostname));
        stringBuffer.append(String.format("%-20s : %-30s \n", "MAC Address", this.macAddress));
        stringBuffer.append(String.format("%-20s : %-30s \n", "VLAN", this.vlanMode));
        stringBuffer.append(String.format("%-20s : %-30s \n", "VLAN ID", this.vlanID));
        stringBuffer.append(String.format("%-20s : %-30s \n", "LAN Interface", this.lanInterface));
        stringBuffer.append(String.format("%-20s : %-30s \n", "RMCP Port", this.rmcpPort));
        stringBuffer.append(String.format("%-20s : %-30s \n", "Active Interface", this.activedInterface));
        stringBuffer.append(System.lineSeparator());
        if (this.isDedicatedSupported(this.supportedMask)) {
            stringBuffer.append("Dedicated").append(System.lineSeparator());
            stringBuffer.append("-------").append(System.lineSeparator());
            stringBuffer.append(String.format("%-20s : %-30s \n", "Link", this.dedicatedLinkMode));
            stringBuffer.append(String.format("%-20s : %-30s \n", "Status", this.dedicatedStatus));
            stringBuffer.append(String.format("%-20s : %-30s \n", "Speed", this.dedicatedSpeed));
            stringBuffer.append(String.format("%-20s : %-30s \n", "Duplex", this.dedicatedDuplex));
            stringBuffer.append(System.lineSeparator());
        }
        if (this.isShareSupported(this.supportedMask)) {
            stringBuffer.append("Share").append(System.lineSeparator());
            stringBuffer.append("-------").append(System.lineSeparator());
            stringBuffer.append(String.format("%-20s : %-30s \n", "Status", this.shareStatus));
            stringBuffer.append(String.format("%-20s : %-30s \n", "Speed", this.shareSpeed));
            stringBuffer.append(String.format("%-20s : %-30s \n", "Duplex", this.shareDuplex));
        }
        MOut.G().println(stringBuffer.toString());
    }

    private void setAttribute(LAN_ACTION_CALLBACK callback) {
        block2: {
            try {
                callback.action();
            }
            catch (Exception ex) {
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL <= 0) break block2;
                ex.printStackTrace();
            }
        }
    }

    private byte[] getLANModeMask(IPMIAMIOEMCommand command) {
        try {
            return command.getLANModeCap();
        }
        catch (IPMIException e2) {
            return null;
        }
    }

    private int getIntegerMask(byte[] maskBytes) {
        int supportedMask = 0;
        if (maskBytes != null) {
            supportedMask = maskBytes[0] & 0xFF;
            if (maskBytes.length > 1) {
                supportedMask |= maskBytes[1] << 8;
            }
        }
        return supportedMask;
    }

    private boolean isDedicatedSupported(int supportedMask) {
        return supportedMask == 0 || (supportedMask & 1) != 0;
    }

    private boolean isShareSupported(int supportedMask) {
        return supportedMask == 0 || (supportedMask & 2) != 0 || (supportedMask & 8) != 0 || (supportedMask & 0x10) != 0 || (supportedMask & 0x80) != 0;
    }

    private static interface LAN_ACTION_CALLBACK {
        public void action() throws Exception;
    }
}

