/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanNetmaskCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            String mask = this.parameters[0];
            if (!IPMILanCommand.isIPAddress(mask)) {
                MOut.G(this).println("Netmask format error!");
                this.statusCode = 147;
                return;
            }
            if (mask.equals("0.0.0.0")) {
                MOut.G(this).println("Netmask cannot be 0.0.0.0!");
                this.statusCode = 147;
                return;
            }
            if (this.isDHCPEnabled(ipmiLanCommand)) {
                MOut.G(this).println("It is not allow to set netmask when DHCP is enalbed");
                this.statusCode = 147;
                return;
            }
            int intValue = ByteUtility.ipToInt(mask);
            if (((0 - intValue & intValue) - 1 | intValue) != -1) {
                MOut.G(this).println("Wrong netmask!");
                this.statusCode = 147;
                return;
            }
            String oldMask = ipmiLanCommand.getSubnetMask();
            boolean result = ipmiLanCommand.setSubnetMask(mask);
            if (result) {
                MOut.G(this).println("old Netmask:" + oldMask);
                MOut.G(this).println("new Netmask:" + mask);
                this.statusCode = 0;
            } else {
                MOut.G(this).println(oldMask);
                MOut.G(this).println("Update Netmask failed");
                this.statusCode = 149;
            }
        } else {
            String mask = ipmiLanCommand.getSubnetMask();
            if (mask != null) {
                MOut.G(this).println(mask);
                this.statusCode = 0;
            } else {
                MOut.G(this).println(MessageCenter.getInstance().getMessage());
                this.statusCode = 148;
            }
        }
    }

    boolean isDHCPEnabled(IPMILanCommand ipmiLanCommand) {
        byte data = ipmiLanCommand.getLanSettingType();
        switch (data) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        MOut.G(this).println("unknown LAN setting");
        return false;
    }
}

