/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIPEFCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanSNMPCommand
extends SuperBladeCommand {
    boolean ackFlag;
    boolean ackAction;
    final int destMinIndex = 1;
    final int destMaxIndex = 15;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand;
        block17: {
            String mac;
            String ip;
            String seqStr;
            byte seq;
            IPMIPEFCommand ipmiPEFCommand;
            block19: {
                block18: {
                    ipmiLanCommand = new IPMILanCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
                    ipmiPEFCommand = new IPMIPEFCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
                    if (this.parameters == null || this.parameters.length != 2 && this.parameters.length != 3 && this.parameters.length != 4) break block17;
                    if (this.checkIfSystemLockdown()) {
                        return;
                    }
                    seq = 0;
                    seqStr = this.parameters[0];
                    ip = this.parameters[1];
                    mac = "00:00:00:00:00:00";
                    this.ackFlag = false;
                    this.ackAction = false;
                    if (this.parameters.length != 3) break block18;
                    if (IPMILanCommand.isMacAddress(this.parameters[2])) {
                        mac = this.parameters[2];
                        break block19;
                    } else {
                        if (!this.parameters[2].equalsIgnoreCase("on") && !this.parameters[2].equalsIgnoreCase("off")) {
                            MOut.G(this).println("Parameters format error!");
                            this.statusCode = 147;
                            return;
                        }
                        this.ackFlag = true;
                        if (this.parameters[2].equalsIgnoreCase("on")) {
                            this.ackAction = true;
                        }
                    }
                    break block19;
                }
                if (this.parameters.length == 4) {
                    mac = this.parameters[2];
                    if (!this.parameters[3].equalsIgnoreCase("on") && !this.parameters[3].equalsIgnoreCase("off")) {
                        MOut.G(this).println("Parameters format error!");
                        this.statusCode = 147;
                        return;
                    }
                    this.ackFlag = true;
                    if (this.parameters[3].equalsIgnoreCase("on")) {
                        this.ackAction = true;
                    }
                }
            }
            try {
                seq = (byte)Integer.parseInt(seqStr);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println("destination number format error!");
                this.statusCode = 147;
                return;
            }
            if (seq < 1 || seq > 15) {
                MOut.G(this).println("destination number is out of range(1 to 15)");
                this.statusCode = 147;
                return;
            }
            if (!IPMILanCommand.isIPAddress(ip)) {
                MOut.G(this).println("IP format error!");
                this.statusCode = 147;
                return;
            }
            if (this.parameters.length == 3 && !IPMILanCommand.isMacAddress(mac)) {
                MOut.G(this).println("MAC format error!");
                this.statusCode = 147;
                return;
            }
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
            if (guid == null) {
                MOut.G(this).println("Unknown GUID");
                this.statusCode = 149;
            }
            ipmiPEFCommand.setPEFControl((byte)1);
            ipmiPEFCommand.setPEFActionGlobalControl((byte)1);
            byte policyNumber = 0;
            boolean b2 = false;
            b2 = IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isNormalBladeCMMGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isOSAGUID(guid) ? this.setPEFforPeppercon(ipmiLanCommand, ipmiPEFCommand, seq, ip, mac, policyNumber) : (IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isAMIAspeedGUID(guid) ? this.setPEFForAMI(ipmiLanCommand, ipmiPEFCommand, seq, ip, mac, policyNumber) : this.setPEFforATEN(ipmiLanCommand, ipmiPEFCommand, seq, ip, mac, policyNumber));
            if (b2) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
            this.printSNMPList(ipmiLanCommand);
            return;
        }
        if (this.printSNMPList(ipmiLanCommand)) {
            this.statusCode = 0;
            return;
        }
        MOut.G(this).println(MessageCenter.getInstance().getMessage());
        this.statusCode = 148;
    }

    private boolean setPEFforPeppercon(IPMILanCommand ipmiLanCommand, IPMIPEFCommand ipmiPEFCommand, byte seq, String ip, String mac, byte policyNumber) {
        boolean b1 = ipmiPEFCommand.setDefaultEventFilterTableEntry((byte)1, policyNumber);
        boolean b2 = ipmiPEFCommand.setDefaultAlertPolicyTableEntry(seq, policyNumber, seq);
        boolean b3 = ipmiLanCommand.setDesitnationIPandMAC(seq, ip, mac);
        boolean b4 = this.ackFlag ? ipmiLanCommand.setPEFSendingAlertTrap(seq, this.ackAction) : ipmiLanCommand.setDefaultPEFDestinationType(seq);
        boolean b5 = b1 && b2 && b3 && b4;
        return b5;
    }

    private boolean setPEFForAMI(IPMILanCommand ipmiLanCommand, IPMIPEFCommand ipmiPEFCommand, byte seq, String ip, String mac, byte policyNumber) {
        boolean b1 = true;
        boolean b2 = true;
        for (int i2 = 1; i2 <= 4; ++i2) {
            if (!ip.equals("0.0.0.0")) {
                boolean isEnable = false;
                byte channel = 0;
                isEnable = true;
                channel = 1;
                b2 &= ipmiPEFCommand.setAlertPolicyTableEntry((byte)((seq - 1) * 4 + i2), (byte)i2, isEnable, channel, seq);
                continue;
            }
            b2 &= ipmiPEFCommand.setAlertPolicyTableEntry((byte)((seq - 1) * 4 + i2), (byte)i2, false, (byte)0, seq);
        }
        boolean b3 = ipmiLanCommand.setDesitnationIPandMAC(seq, ip, mac);
        boolean b4 = this.ackFlag ? ipmiLanCommand.setPEFSendingAlertTrap(seq, this.ackAction) : ipmiLanCommand.setDefaultPEFDestinationType(seq);
        boolean b5 = b1 && b2 && b3 && b4;
        return b5;
    }

    private boolean setPEFforATEN(IPMILanCommand ipmiLanCommand, IPMIPEFCommand ipmiPEFCommand, byte seq, String ip, String mac, byte policyNumber) {
        boolean b1 = ip.equals("0.0.0.0") ? ipmiPEFCommand.setDefaultDisableEventFilterTableEntryForATEN((byte)(seq + 1)) : ipmiPEFCommand.setDefaultEventFilterTableEntryForATEN((byte)(seq + 1), (byte)4);
        boolean b2 = ipmiPEFCommand.setDefaultAlertPolicyTableEntry((byte)(seq + 1), (byte)4, seq);
        boolean b3 = ipmiLanCommand.setDesitnationIPandMAC(seq, ip, mac);
        boolean b4 = this.ackFlag ? ipmiLanCommand.setPEFSendingAlertTrap(seq, this.ackAction) : ipmiLanCommand.setDefaultPEFDestinationType(seq);
        boolean b5 = b1 && b2 && b3 && b4;
        return b5;
    }

    private boolean printSNMPList(IPMILanCommand ipmiLanCommand) {
        String format = "%3s %20s %20s %20s\n";
        for (byte i2 = 1; i2 <= 15; i2 = (byte)(i2 + 1)) {
            String ack;
            byte[] destinationType = ipmiLanCommand.getDestinationType(i2);
            if (destinationType == null) {
                return false;
            }
            if (i2 == 1) {
                MOut.G(this).printf(format, "Seq", "IP", "MAC", "Acknowledge");
                MOut.G(this).printf(format, "---", "--", "---", "-----------");
            }
            String ip = ipmiLanCommand.getDestinationIP(i2);
            String mac = ipmiLanCommand.getDestinationMAC(i2);
            String string = destinationType.length > 3 ? (destinationType[2] > 0 && destinationType[3] > 0 ? "On" : "Off") : (ack = "Off");
            if (null == ip || null == mac) {
                ip = "N/A";
                mac = "N/A";
                ack = "N/A";
            }
            MOut.G(this).printf(format, i2, ip, mac, ack);
        }
        return true;
    }
}

