/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;

public class IPMIOEMAlertListCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters != null && this.parameters.length == 1 && (Integer.parseInt(this.parameters[0]) < 1 || Integer.parseInt(this.parameters[0]) > 16)) {
            MOut.G(this).println("Parameter error!");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported() || !this.isBeforeX12()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            MOut.G(this).println("--------------------------------------------------------------------------------");
            for (int i2 = 0; i2 < 16; ++i2) {
                byte[] bytes = ipmiOEMWebSettingCommand.getAlert((byte)i2, (byte)0);
                byte level = bytes[0];
                String ip = bytes.length > 1 ? String.format("%s.%s.%s.%s", bytes[1] & 0xFF, bytes[2] & 0xFF, bytes[3] & 0xFF, bytes[4] & 0xFF) : "";
                String mail = new String(ipmiOEMWebSettingCommand.getAlert((byte)i2, (byte)1));
                String subject = new String(ipmiOEMWebSettingCommand.getAlert((byte)i2, (byte)2));
                String message = new String(ipmiOEMWebSettingCommand.getAlert((byte)i2, (byte)3));
                MOut.G(this).println(String.format("%2d. Event Severity      : %s", i2 + 1, this.levelString(level)));
                MOut.G(this).println("    Destination Address : " + (ip.length() == 0 ? "N/A" : ip) + " & " + (mail.length() == 0 ? "N/A" : mail));
                MOut.G(this).println("    Subject             : " + (subject.length() == 0 ? "N/A" : subject));
                MOut.G(this).println("    Message             : " + (message.length() == 0 ? "N/A" : message));
                MOut.G(this).println("--------------------------------------------------------------------------------");
            }
        } else {
            int index = Integer.parseInt(this.parameters[0]) - 1;
            byte[] bytes = ipmiOEMWebSettingCommand.getAlert((byte)index, (byte)0);
            byte level = bytes[0];
            String ip = bytes.length > 1 ? String.format("%s.%s.%s.%s", bytes[1] & 0xFF, bytes[2] & 0xFF, bytes[3] & 0xFF, bytes[4] & 0xFF) : "";
            String mail = new String(ipmiOEMWebSettingCommand.getAlert((byte)index, (byte)1));
            String subject = new String(ipmiOEMWebSettingCommand.getAlert((byte)index, (byte)2));
            String message = new String(ipmiOEMWebSettingCommand.getAlert((byte)index, (byte)3));
            MOut.G(this).println(String.format("%2d. Event Severity      : %s", index + 1, this.levelString(level)));
            MOut.G(this).println("    Destination Address : " + (ip.length() == 0 ? "N/A" : ip) + " & " + (mail.length() == 0 ? "N/A" : mail));
            MOut.G(this).println("    Subject             : " + (subject.length() == 0 ? "N/A" : subject));
            MOut.G(this).println("    Message             : " + (message.length() == 0 ? "N/A" : message));
        }
        this.statusCode = 0;
    }

    private String levelString(byte type) {
        switch (type) {
            case 0: {
                return "Disable All";
            }
            case 2: {
                return "Information and Above";
            }
            case 8: {
                return "Warning and Above";
            }
            case 16: {
                return "Critical and Above";
            }
            case 32: {
                return "Non-recoverable and Above";
            }
        }
        return "N/A";
    }
}

