/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.nio.ByteBuffer;

public class IPMIOEMIpCtrlDeleteCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private byte id;

    @Override
    public boolean preValidate() {
        String usage = "delete <rule no>";
        if (this.parameters == null || this.parameters.length != 1) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.id = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("rule no should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.id < 1 || this.id > 10) {
            MOut.G(this).println("rule no should be 1-10");
            MOut.G(this).println(usage);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        if (!this.isBeforeX12()) {
            MOut.G(this).println("IPCtrl command is not supported on this device, you may try redfish ipctrl command instead.");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        ByteBuffer target = ByteBuffer.allocate(1);
        this.id = (byte)(this.id - 1);
        target.put(this.id);
        if (!ipmiOEMWebSettingCommand.setIpCtrl((byte)2, target.array())) {
            MOut.G(this).println("Delete ip access rule failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

