/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;

public class IPMIOEMNTPStateCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private static final byte NTPSetting = 0;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && !this.parameters[0].equalsIgnoreCase("enable") && !this.parameters[0].equalsIgnoreCase("disable")) {
            MOut.G(this).println("Parameter error!");
            MOut.G(this).println("Usage: ipmi oem x10cfg ntp state [enable|disable]");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        IPMIOEMWebSettingCommand command = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] ntpData = command.getNTPDateTime((byte)0);
        if (this.parameters == null) {
            MOut.G(this).println(ntpData[0] == 0 ? "Disable" : "Enable");
            this.statusCode = 0;
        } else {
            boolean isAutoDSTSupport;
            if (this.checkIfSystemLockdown()) {
                return;
            }
            boolean bl = isAutoDSTSupport = !IPMIOEMWebSettingCommand.isNTPLegacyResponse(ntpData);
            if (this.parameters[0].equalsIgnoreCase("enable")) {
                ntpData[0] = isAutoDSTSupport ? (byte)1 : 1;
            } else if (this.parameters[0].equalsIgnoreCase("disable")) {
                byte by = ntpData[0] = isAutoDSTSupport ? (byte)0 : 0;
            }
            if (isAutoDSTSupport) {
                try {
                    command.setNewNTPSettings(ntpData);
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                }
                catch (IPMIException ex) {
                    MOut.G(this).println("Failed" + "");
                    this.statusCode = 149;
                }
            } else {
                command.setNTPDateTime((byte)0, ntpData);
                MOut.G(this).println("Done");
                this.statusCode = 0;
            }
        }
    }
}

