/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.SMTPRedfishHelper;

public class IPMIOEMSMTPServerCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    @Override
    public boolean preValidate() {
        boolean result = true;
        if (this.parameters != null && this.parameters.length > 0) {
            if (IPMILanCommand.isIPAddress(this.parameters[0]) || IPMILanCommand.isValidateDomain(this.parameters[0]) || RedfishHttpUtils.isIPv6(this.parameters[0])) {
                result = true;
            } else {
                MOut.G(this).println("It is a illegal IP address or domain name");
                this.statusCode = 147;
                result = false;
            }
        }
        return result;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        if (SMTPRedfishHelper.isSupportedRedfishSMTP(this.config)) {
            MOut.G(this).println("SMTP command is not supported on this device, you may try redfish eventService smtp command instead.");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            byte[] serverData = ipmiOEMWebSettingCommand.getSMTP((byte)1);
            MOut.G(this).println(new String(serverData));
        } else {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            byte[] smtpServer = new byte[this.parameters[0].length() + 1];
            System.arraycopy(this.parameters[0].getBytes(), 0, smtpServer, 0, this.parameters[0].length());
            ipmiOEMWebSettingCommand.setSMTP((byte)1, smtpServer);
            MOut.G(this).println("Done");
        }
        this.statusCode = 0;
    }
}

