/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIOEMWebSessionCommand
extends SuperBladeCommand {
    byte session = (byte)60;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            try {
                this.session = Byte.parseByte(this.parameters[0]);
            }
            catch (NumberFormatException e2) {
                this.printUsage();
                return false;
            }
            if (this.session < 0 || this.session > 30) {
                this.printUsage();
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIOEMCommand ipmioemCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            MOut.G(this).println("Current web session timeout :" + ipmioemCommand.getWebSessionTimeout() + " minute(s)");
        } else if (ipmioemCommand.setWebSessionTimeout(this.session)) {
            MOut.G(this).println("Setting web session done");
        } else {
            MOut.G(this).println("Setting web session failed");
            this.statusCode = 149;
            return;
        }
        this.statusCode = 0;
    }

    public void printUsage() {
        MOut.G(this).println("Usage: ipmi oem webSession [timeout] ");
        MOut.G(this).println("Timeout: 0~30 in minutes. 0 means no timeout.");
    }
}

