/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIPowerSupplyFWUpdater;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class IPMIPSUUpdateCommand
extends SuperBladeCommand {
    byte slaveAddr;
    String filename;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 2) {
            MOut.G(this).println("Usage: psu update <slaveAddr> <file>");
            this.statusCode = 147;
            return false;
        }
        try {
            this.slaveAddr = (byte)Integer.parseInt(this.parameters[0], 16);
        }
        catch (NumberFormatException e2) {
            MOut.G(this).println(e2.getMessage());
            this.statusCode = 147;
            return false;
        }
        this.filename = this.parameters[1];
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        String pubKeyStr = "30820122300d06092a864886f70d01010105000382010f003082010a0282010100dfdb963c5b3ae94d6dcbeaa4f6492d6c6dad0ef6fd778235fc4a088cb42ea9dc66d7b9906c1c7147ab24bf511e3bbb4c94d1642b93f8225d46d5e7caceef5d34bb4c4c4f3f012b1614af6b3ea87d46f32d4887c91a94a772da51a10f85c7fffdfaba38190f44e044d29dcd9a5ae0da4f8af7ec94465e550269b699d2cedad5d28cff07d41b6b80794a7cdf7f85ce829947bc14474dcfb1e17799fdb09ac42fcb13b108225b1307bdce2e2026b5fa8f97b5b7e707b87ab9896039fe2681547cf0a39ca3b695b63c8e1074159bb70eccee983e4a59746fc5e708fd707469736d578f3fda371855241371d1cd7730a6b81c20eebc0d163faf1673ffeb372b9cecfb0203010001";
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(new BigInteger(pubKeyStr, 16).toByteArray());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Path path = Paths.get(this.filename, new String[0]);
        byte[] originalContent = Files.readAllBytes(path);
        byte[] fwContent = Arrays.copyOfRange(originalContent, 0, originalContent.length - 1416);
        byte[] signedContent = Arrays.copyOfRange(originalContent, originalContent.length - 256, originalContent.length);
        Signature sig = Signature.getInstance("SHA256withRSA");
        sig.initVerify(pubKey);
        sig.update(fwContent);
        boolean verified = sig.verify(signedContent);
        if (!verified) {
            MOut.G(this).println("Update package verification failed");
            return;
        }
        MOut.G(this).println("Update package verified");
        MOut.G(this).println("**************************************************************");
        MOut.G(this).println("WARNING!");
        MOut.G(this).println("**************************************************************");
        IPMIPowerSupplyFWUpdater updater = new IPMIPowerSupplyFWUpdater(this.ipmiCMMOEMCommand.getIPMIInterface());
        updater.setMOut(MOut.G(this));
        updater.setFirmwareName(this.filename);
        updater.update(this.slaveAddr);
        this.statusCode = 0;
    }
}

