/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIRawCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 2) {
            MOut.G(this).println("<netFn> <cmd> [data] parameters required.");
            this.statusCode = 147;
            return false;
        }
        if (this.parameters[0].contains("0x") || this.parameters[1].contains("0x")) {
            MOut.G(this).println("<netFn> <cmd> [data] The parameters are serial of hex value.");
            MOut.G(this).print("Example: ipmi raw " + this.parameters[0].replace("0x", "") + " " + this.parameters[1].replace("0x", ""));
            if (this.parameters.length > 2) {
                for (int p = 2; p < this.parameters.length; ++p) {
                    MOut.G(this).print(" " + this.parameters[p]);
                }
            }
            MOut.G(this).println(" (The 0x prefix is not required)");
            this.statusCode = 147;
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] data;
        byte cmd;
        byte netfn;
        try {
            netfn = (byte)Integer.parseInt(this.parameters[0], 16);
            cmd = (byte)Integer.parseInt(this.parameters[1], 16);
            int dataSize = this.parameters.length - 2;
            data = new byte[dataSize];
            for (int i2 = 0; i2 < dataSize; ++i2) {
                data[i2] = (byte)Integer.parseInt(this.parameters[2 + i2], 16);
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        IPMIMessage ipmiMessage = new IPMIMessage();
        netfn = (byte)(netfn << 2);
        ipmiMessage.setCommandAndData(netfn, cmd, data);
        IPMIMessage resMessage = this.ipmiCMMOEMCommand.getIPMIInterface().send(ipmiMessage);
        if (resMessage != null) {
            MOut.G(this).println(ByteUtility.byteToHex(resMessage.completionCode));
            if (resMessage.completionCode != 0) {
                MOut.G(this).println("(" + GlobalDefine.getCompletionCodeString(resMessage.completionCode) + ")");
                this.statusCode = 149;
            }
            if (resMessage.data != null) {
                if (resMessage.data.length != 0) {
                    MOut.G(this).println(ByteUtility.bytesToHex(resMessage.data));
                }
                this.statusCode = 0;
            } else {
                this.statusCode = 149;
            }
        } else {
            this.statusCode = 149;
        }
    }
}

