/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMITASCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMITASExecCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMITASCommand ipmiTasCommand = new IPMITASCommand(null);
        ipmiTasCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] key = IPMITASCommand.getModifiedMacAsKey();
        if (this.parameters != null && this.parameters.length == 1) {
            String command = this.parameters[0];
            byte[] b2 = command.getBytes();
            if (b2.length == 0) {
                MOut.G(this).println("Empty Command");
                this.statusCode = 147;
            }
            if (ipmiTasCommand.isFlagAvailable()) {
                boolean result = ipmiTasCommand.TasEXECbyKey(key, b2);
                if (result) {
                    byte[] response;
                    int i2 = 0;
                    while ((response = ipmiTasCommand.getCommandResponse()) == null) {
                        Thread.sleep(1000L);
                        if (++i2 < 10) continue;
                    }
                    if (response == null) {
                        MOut.G(this).println("Command timeOut, please try again.");
                        this.statusCode = 149;
                        return;
                    }
                    if (IPMITASCommand.compareKeyFromResponse(key, response)) {
                        MOut.G(this).println("Done");
                        this.statusCode = 0;
                    } else {
                        MOut.G(this).println("Command fail, please try again.");
                        this.statusCode = 149;
                    }
                } else {
                    MOut.G(this).println("Command execute fail");
                    this.statusCode = 149;
                }
            } else {
                MOut.G(this).println("TAS command area has been occupied, please resend the command later.");
                this.statusCode = 0;
            }
        } else {
            MOut.G(this).println("Parameter error!");
            this.statusCode = 147;
        }
    }
}

