/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.LicenseManager;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class MBTDeactivateKeyCommand
extends SuperBladeCommand {
    public static final int LICENSE_ID_OOB = 0;
    public static final int LICENSE_ID_DCMS_SINGLE = 1;
    public static final int LICENSE_ID_SPM = 2;
    public static final int LICENSE_ID_DCMS_SVC = 3;
    public static final String LICENSE_PARAMETER_OOB = "-oob";
    public static final String LICENSE_PARAMETER_DCMS_SINGLE = "-dcms";
    private int deactivateType;

    @Override
    public boolean preValidate() {
        this.deactivateType = 0;
        if (this.parameters != null && this.parameters.length > 0 && this.parameters[0].equals(LICENSE_PARAMETER_DCMS_SINGLE)) {
            this.deactivateType = 1;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        LicenseManager manager = new LicenseManager(this.ipmiCMMOEMCommand.getIPMIInterface(), this.config);
        try {
            if (this.deactivateType == 0) {
                manager.clearOOBLicense();
            } else if (this.deactivateType == 1) {
                manager.clearDCMSLicense();
            }
            this.statusCode = 0;
            MOut.G(this).println("Deactivated " + (this.deactivateType == 0 ? "SFT-OOB-LIC" : "SFT-DCMS-SINGLE") + " Product Key ... Done");
        }
        catch (Exception ex) {
            this.statusCode = 149;
            MOut.G(this).println("Deactivated " + (this.deactivateType == 0 ? "SFT-OOB-LIC" : "SFT-DCMS-SINGLE") + " Product Key ... Failed");
        }
    }
}

