/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.text.MBTLinkService;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;

public class MBTROTCPLDUpdateCommand
extends SuperBladeCommand {
    private final byte OPCODE_CPLD_UPDATE = (byte)13;
    private final int LINK_RECOVERY_TTL = 80;
    private int customizedTTL = 0;

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Filename is needed");
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        if (this.parameters.length > 1) {
            try {
                this.customizedTTL = Integer.valueOf(this.parameters[1]);
            }
            catch (NumberFormatException e2) {
                this.customizedTTL = -1;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean result = ipmiBMCFileCommand.generalFileUpload((byte)13, this.parameters[0]);
        if (!result) {
            MOut.G(this).println("CPLD update failed.");
            this.statusCode = 149;
            return;
        }
        this.ignoreSessionClose(true);
        result = MBTLinkService.isLinkRecovery(this, this.customizedTTL > 0 ? this.customizedTTL : 80);
        this.statusCode = result ? 0 : 149;
    }
}

