/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMRoTCommand;
import com.supermicro.ipmi.text.MBTLinkService;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class MBTROTEraseCommand
extends SuperBladeCommand {
    private boolean isEraseBMC;
    private boolean isEraseBIOS;
    private boolean isBackupRegion;
    private boolean isStagingRegion;
    private boolean isNeedReboot;

    @Override
    public boolean preValidate() {
        this.isEraseBMC = false;
        this.isEraseBIOS = false;
        this.isBackupRegion = false;
        this.isStagingRegion = false;
        this.isNeedReboot = false;
        for (int index = 0; null != this.parameters && index < this.parameters.length; ++index) {
            String param = this.parameters[index];
            if (param.equalsIgnoreCase("-bmc")) {
                this.isEraseBMC = true;
            }
            if (param.equalsIgnoreCase("-bios")) {
                this.isEraseBIOS = true;
            }
            if (param.equalsIgnoreCase("-backup")) {
                this.isBackupRegion = true;
            }
            if (param.equalsIgnoreCase("-staging")) {
                this.isStagingRegion = true;
            }
            if (!param.equalsIgnoreCase("-reboot")) continue;
            this.isNeedReboot = true;
        }
        if (!(this.isEraseBMC ^ this.isEraseBIOS) || !(this.isBackupRegion ^ this.isStagingRegion)) {
            MOut.G(this).println("Parameters failed");
            MOut.G(this).println("");
            this.usage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        boolean result = false;
        IPMIOEMRoTCommand rotCommand = new IPMIOEMRoTCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.isEraseBMC && this.isBackupRegion) {
            result = rotCommand.eraseBMCBackupImage();
        } else if (this.isEraseBMC && this.isStagingRegion) {
            result = rotCommand.eraseBMCStagingImage();
        } else if (this.isEraseBIOS && this.isBackupRegion) {
            result = rotCommand.eraseBIOSBackupImage();
        } else if (this.isEraseBIOS && this.isStagingRegion) {
            result = rotCommand.eraseBIOSStagingImage();
        }
        MOut.G(this).println(result ? "Done. BMC will run the requested operations in next cold rest." : "Erase failed");
        int n = this.statusCode = result ? 0 : 149;
        if (this.isNeedReboot) {
            result = MBTLinkService.setColdReset(this);
            if (result) {
                result = MBTLinkService.isLinkRecovery(this);
            }
            this.statusCode = result ? 0 : 149;
        }
    }

    private void usage() {
        MOut.G(this).println("Flash:");
        MOut.G(this).println("-bmc             Erase BMC backup/staging");
        MOut.G(this).println("-bios            Erase BIOS backup/staging");
        MOut.G(this).println("Region:");
        MOut.G(this).println("-backup          To erase backup region");
        MOut.G(this).println("-staging         To erase staging region");
        MOut.G(this).println("Preserve_opt:");
        MOut.G(this).println("-reboot          Cold reset and wait for connection recovery");
    }
}

