/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMRoTCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class MBTROTProvisionStartCommand
extends SuperBladeCommand {
    public static final int PROVISION_STATE_IDEL = 0;
    public static final int PROVISION_STATE_RUNNING = 1;
    public static final int PROVISION_STATE_FINISHED = 2;
    public static final int PROVISION_STATE_FINISHED_ERROR = 3;
    public static final int PROVISION_STATE_RUN_BEFORE = 4;

    @Override
    public void runCommand() throws Exception {
        IPMIOEMRoTCommand command = new IPMIOEMRoTCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        int beginState = this.provisionStateMonitor(command);
        switch (beginState) {
            case 0: 
            case 2: 
            case 3: {
                if (this.runProvisionTask(command)) {
                    MOut.G(this).println("Provision procedure exit.");
                    this.statusCode = 0;
                } else {
                    MOut.G(this).println("Provision procedure failed.");
                    this.statusCode = 149;
                }
                this.ignoreSessionClose(true);
                break;
            }
            case 1: 
            case 4: {
                MOut.G(this).println("Provision is running or run before state. Please wait until it finished.");
                this.statusCode = 149;
                break;
            }
            default: {
                MOut.G(this).println("Unknown state: " + beginState);
                this.statusCode = 149;
            }
        }
    }

    private boolean runProvisionTask(IPMIOEMRoTCommand command) {
        if (command.setProvisionStart()) {
            MOut.G(this).println("Provision start");
            long beginTimestamp = System.currentTimeMillis();
            long timeElapsedLimit = 1200000L;
            boolean execResult = false;
            IPMIOEMRoTCommand rotCommand = new IPMIOEMRoTCommand(null);
            ISessionController sessionController = null;
            do {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                if (null == sessionController && null == (sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.config, rotCommand))) continue;
                int state = this.provisionStateMonitor(rotCommand);
                if (state == 2) {
                    execResult = true;
                    break;
                }
                if (state == 3) {
                    execResult = false;
                    break;
                }
                if (state == 0 || state == 213) {
                    execResult = false;
                    break;
                }
                execResult = false;
            } while (System.currentTimeMillis() - beginTimestamp <= 1200000L);
            if (null != sessionController) {
                sessionController.closeSession();
            }
            return execResult;
        }
        return false;
    }

    private int provisionStateMonitor(IPMIOEMRoTCommand command) {
        int state = command.getProvisionState();
        this.provisionStatePrinter(state);
        return state;
    }

    private void provisionStatePrinter(int state) {
        MOut.G(this).print("Provision state: ");
        switch (state) {
            case 0: {
                MOut.G(this).println("idle");
                break;
            }
            case 1: {
                MOut.G(this).println("running");
                break;
            }
            case 2: {
                MOut.G(this).println("finished");
                break;
            }
            case 3: {
                MOut.G(this).println("finished with error");
                break;
            }
            case 4: {
                MOut.G(this).println("run before");
                break;
            }
            default: {
                MOut.G(this).println("Unknown error " + state);
            }
        }
    }
}

