/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMITwinProCommand;
import com.supermicro.ipmi.IPMITwinProMCUUpdater;
import com.supermicro.ipmi.IPMITwinProNXMCUUpdater;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.RedfishFlash;
import com.supermicro.redfish.RedfishHttpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.HashMap;

public class MCUUpdateCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("MCU filename is needed");
            MOut.G(this).println("Usage: tp mcuUpdate <filename>");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMITwinProCommand ipmiTwinProCommand = new IPMITwinProCommand(null);
        ipmiTwinProCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            if (!ipmiTwinProCommand.isSupportTwinProCommand()) {
                this.statusCode = 153;
                MOut.G(this).println("Not supported device");
                return;
            }
        }
        catch (Exception e2) {
            this.statusCode = 153;
            MOut.G(this).println("Cannot get MCU Info");
            return;
        }
        if (ipmiTwinProCommand.getConfigID() == 12) {
            this.statusCode = 153;
            MOut.G(this).println("Not supported device");
            return;
        }
        byte[] dataToWrite = new byte[]{-3};
        byte readCount = 1;
        byte mcuID = ipmiTwinProCommand.sendTwinPro80hCommand(readCount, dataToWrite)[0];
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (!IPMIMessagingCommand.isBeforeX12(guid) && mcuID == -90 || mcuID == -77) {
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            if (ipmiChassisCommand.isPowerOn()) {
                MOut.G(this).println("Updating procedure requires system power off");
                this.statusCode = 149;
                return;
            }
            try {
                if (this.redfishMultiNodeUpdate()) {
                    this.ignoreSessionClose(true);
                    this.statusCode = 0;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MOut.G(this).println("*****************************************************");
        MOut.G(this).println(" WARNING!");
        MOut.G(this).println(" The whole Twin system will be shutdown after update");
        MOut.G(this).println("*****************************************************");
        MOut.G(this).println();
        byte[] fileByteArray = this.readToByteArray(this.parameters[0]);
        if (mcuID == -88 || mcuID == -89 || mcuID == -90 || mcuID == -79 || mcuID == -64 || mcuID == -78) {
            IPMITwinProNXMCUUpdater updater = new IPMITwinProNXMCUUpdater(this.ipmiCMMOEMCommand.getIPMIInterface());
            updater.setMOut(MOut.G(this));
            updater.setMCUFirmwareName(this.parameters[0]);
            updater.setMCUFirmware(fileByteArray);
            if (this.parameters.length == 2 && this.parameters[this.parameters.length - 1].toLowerCase().contains("-force_update")) {
                updater.setPassChecking(true);
            }
            this.statusCode = updater.update(mcuID) ? 0 : 149;
        } else {
            IPMITwinProMCUUpdater updater = new IPMITwinProMCUUpdater(this.ipmiCMMOEMCommand.getIPMIInterface());
            updater.setMOut(MOut.G(this));
            updater.setMCUFirmwareName(this.parameters[0]);
            this.statusCode = updater.update() ? 0 : 149;
        }
    }

    private byte[] readToByteArray(String filename) throws Exception {
        byte[] getBytes = new byte[]{};
        try {
            File file = new File(filename);
            getBytes = new byte[(int)file.length()];
            FileInputStream is = new FileInputStream(file);
            int readCount = ((InputStream)is).read(getBytes);
            if (readCount < 0) {
                MOut.G(this).println(" File read fail.");
            }
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e2) {
            throw new FileNotFoundException(" File is not exist.");
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return getBytes;
    }

    public boolean redfishMultiNodeUpdate() throws Exception {
        String url = "https://" + this.config.getIp() + "/redfish/v1/UpdateService/" + "FirmwareInventory";
        RedfishHttpUtils utils = new RedfishHttpUtils();
        utils.sendRedfishGet(this.config, url);
        HashMap<String, String> entryMap = utils.getEntry();
        String word = "/LCMC_Multinode";
        if (!entryMap.get("Members").contains("LCMC_Multinode") && entryMap.get("Members").contains("LCMC_Backplane")) {
            word = "/LCMC_Backplane";
        }
        url = "https://" + this.config.getIp() + "/redfish/v1/UpdateService/" + "FirmwareInventory" + word;
        utils.sendRedfishGet(this.config, url);
        entryMap = utils.getEntry();
        MOut.G(this).println("**************************************************************");
        MOut.G(this).println("WARNING!");
        MOut.G(this).println("CPLD/LCMC upgrade must not be interrupted once it is started.");
        MOut.G(this).println("All nodes will perform BMC reset after update.");
        MOut.G(this).println("**************************************************************");
        String body = "{\"Targets\":[\"/redfish/v1/UpdateService/FirmwareInventory" + word + "\"],\r\n\"@Redfish.OperationApplyTime\":\"Immediate\"\r\n}";
        MOut.G(this).println("Existing LCMC_Multinode version: " + entryMap.get("Version").toUpperCase());
        MOut.G(this).println("");
        RedfishFlash redfishFlash = new RedfishFlash();
        redfishFlash.setMOut(MOut.G(this));
        if (redfishFlash.flashBIOS(this.config, this.parameters[0], body)) {
            int retry = 250;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (retry > 0) {
                InetAddress address = InetAddress.getByName(this.config.getIp());
                boolean result = address.isReachable(3000);
                if (result) {
                    try {
                        Thread.sleep(10000L);
                        if (address.isReachable(3000)) break;
                        result = false;
                    }
                    catch (Exception ex) {
                        result = false;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --retry;
            }
            if (retry == 0) {
                MOut.G(this).println("BMC IP is unavailable currently. Please check after 2 minutes later");
            }
            utils.sendRedfishGet(this.config, url);
            entryMap = utils.getEntry();
            MOut.G(this).println("");
            MOut.G(this).println("Current LCMC_Multinode version: " + entryMap.get("Version").toUpperCase());
            return true;
        }
        return false;
    }
}

