/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.MarvellRaidCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class MarvellVPDWriteCommand
extends SuperBladeCommand {
    String field;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 2) {
            this.printUsage();
            return false;
        }
        this.field = this.parameters[0].toUpperCase();
        if (this.field.equals("PN") || this.field.equals("AOC") || this.field.equals("SN") || this.field.equals("FW") || this.field.equals("MFG") || this.field.equals("BATCH") || this.field.equals("CONTROLLER")) {
            return true;
        }
        this.printUsage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        MarvellRaidCommand marvellRaidCommand = new MarvellRaidCommand(null);
        marvellRaidCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.field.equals("PN")) {
            if (this.parameters[1].length() > 24) {
                MOut.G(this).println("Maximum length of PN is 24");
                this.statusCode = 149;
                MOut.G(this).println("Done");
                return;
            }
            if (marvellRaidCommand.writePN(this.parameters[1])) {
                marvellRaidCommand.StoreSPIFlash((byte)1, (byte)0);
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Set PN failed");
            this.statusCode = 149;
            return;
        }
        if (this.field.equals("AOC")) {
            if (this.parameters[1].length() > 8) {
                MOut.G(this).println("Maximum length of AOC is 8");
                this.statusCode = 149;
                return;
            }
            if (marvellRaidCommand.writePCBVersion(this.parameters[1])) {
                marvellRaidCommand.StoreSPIFlash((byte)1, (byte)0);
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Set AOC failed");
            this.statusCode = 149;
            return;
        }
        if (this.field.equals("SN")) {
            if (this.parameters[1].length() > 24) {
                MOut.G(this).println("Maximum length of Serial Number is 24");
                this.statusCode = 149;
                return;
            }
            if (marvellRaidCommand.writeSerialNumber(this.parameters[1])) {
                marvellRaidCommand.StoreSPIFlash((byte)1, (byte)0);
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Set SN failed");
            this.statusCode = 149;
            return;
        }
        if (this.field.equals("FW")) {
            if (this.parameters[1].length() > 29) {
                MOut.G(this).println("Maximum length of FW Version is 29");
                this.statusCode = 149;
                return;
            }
            if (marvellRaidCommand.writeFWVersion(this.parameters[1])) {
                marvellRaidCommand.StoreSPIFlash((byte)1, (byte)0);
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Set FW failed");
            this.statusCode = 149;
            return;
        }
        if (this.field.equals("MFG")) {
            if (this.parameters[1].length() != 16) {
                MOut.G(this).println("Length of MfgDateTime must less than 16. (YYYYMMDDHHMMSSCC)");
                this.statusCode = 149;
                return;
            }
            if (marvellRaidCommand.writeMfgDateTime(this.parameters[1])) {
                marvellRaidCommand.StoreSPIFlash((byte)1, (byte)0);
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Set MFG failed");
            this.statusCode = 149;
            return;
        }
        if (this.field.equals("BATCH")) {
            if (this.parameters[1].length() > 8) {
                MOut.G(this).println("Maximum length of Batch is 8");
                this.statusCode = 149;
                return;
            }
            if (marvellRaidCommand.writeBatch(this.parameters[1])) {
                marvellRaidCommand.StoreSPIFlash((byte)1, (byte)0);
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Set Batch failed");
            this.statusCode = 149;
            return;
        }
        if (this.field.equals("CONTROLLER")) {
            if (this.parameters[1].length() > 24) {
                MOut.G(this).println("Maximum length of Controller is 24");
                this.statusCode = 149;
                return;
            }
            if (marvellRaidCommand.writeController(this.parameters[1])) {
                marvellRaidCommand.StoreSPIFlash((byte)1, (byte)0);
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            MOut.G(this).println("Set Controller failed");
            this.statusCode = 149;
            return;
        }
    }

    void printUsage() {
        MOut.G(this).println("Usage: MarvellVPD write <field> <value>");
        MOut.G(this).println("Available Fields for VPD:");
        MOut.G(this).println("    PN         :PN");
        MOut.G(this).println("    AOC        :AOC Version");
        MOut.G(this).println("    SN         :Serial Number");
        MOut.G(this).println("    FW         :Firmware Version");
        MOut.G(this).println("    MFG        :Mfg. Date/Time(YYYYMMDDHHMMSSCC)");
        MOut.G(this).println("    Batch      :Batch");
        MOut.G(this).println("    Controller :Controller");
    }
}

