/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class MetaSwitchBoardUpdateCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Filename is needed");
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        block16: {
            IPMIMessage percentageMessage;
            String fileName = this.parameters[0];
            FileReader fr = null;
            try {
                fr = new FileReader(fileName);
            }
            catch (FileNotFoundException e2) {
                MOut.G(this).println("Open file fail");
                this.statusCode = 147;
                return;
            }
            MOut.G(this).println("================");
            MOut.G(this).println(" Uploading file");
            MOut.G(this).println("================");
            IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            boolean result = ipmiBMCFileCommand.generalFileUpload((byte)19, fileName);
            MOut.G(this).println();
            MOut.G(this).println("===============");
            MOut.G(this).println(" Updating file");
            MOut.G(this).println("===============");
            for (int i2 = 0; i2 < 10; ++i2) {
                IPMIMessage message = ipmiOEMCommand.calculateMCUUpdateStatus();
                if (message.completionCode == 0) {
                    if (message.data[0] == 64 || message.data[0] == 4) break;
                    if (i2 == 9) {
                        MOut.G(this).println("Update fail. CPLD file may be invalid.");
                        this.statusCode = 149;
                        return;
                    }
                } else {
                    MOut.G(this).println("MCU update status: " + ByteUtility.byteToHex(message.completionCode));
                    this.statusCode = 149;
                    return;
                }
                Thread.sleep(1000L);
            }
            MOut.G(this).print("Progress:|");
            int targetRate = 0;
            int curRate = 0;
            int updatingTimeout = 300;
            boolean flag = false;
            int j2 = 0;
            while (true) {
                if (j2 > updatingTimeout * 2) {
                    MOut.G(this).println("Timeout, update CPLD failed.");
                    this.statusCode = 149;
                    return;
                }
                percentageMessage = ipmiOEMCommand.getCPLDUpdatePercentage();
                if (percentageMessage.completionCode != 0) break;
                byte percentage = percentageMessage.data[0];
                targetRate = percentage / 3;
                while (curRate < targetRate) {
                    if (flag) {
                        MOut.G(this).print(">");
                    }
                    flag = true;
                    ++curRate;
                }
                if (percentage < 100) {
                    ++j2;
                    Thread.sleep(500L);
                    continue;
                }
                break block16;
                break;
            }
            MOut.G(this).println();
            switch (percentageMessage.completionCode) {
                case -3: {
                    MOut.G(this).println("CPLD update fail.");
                    break;
                }
                case -2: {
                    MOut.G(this).println("The uploaded file is invalid.");
                    break;
                }
                case -1: {
                    MOut.G(this).println("Firmware does not exists.");
                }
            }
            MOut.G(this).println("Update fail.");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("| 100%");
        MOut.G(this).println("Update success, BMC may disconnect in short time");
        this.statusCode = 0;
    }
}

