/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;

public abstract class MicroBladeCommand
extends Command {
    protected IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = null;
    ISessionController sessionController = null;
    boolean isSessionClosed = false;

    @Override
    public void execute() throws Exception {
        GlobalDefine.PAUSE_DEBUG = true;
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        boolean b2 = this.preValidate();
        if (!b2) {
            this.statusCode = 147;
            return;
        }
        this.ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        try {
            this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, this.ipmiMicroBladeOEMCommand);
        }
        catch (IPMIException ex) {
            MOut.G(this).println(ex.getMessage());
            String message = ex.getMessage();
            if (message.indexOf("connect") != -1) {
                this.statusCode = 145;
            } else if (message.indexOf("login") != -1) {
                this.statusCode = 146;
            }
            return;
        }
        try {
            GlobalDefine.PAUSE_DEBUG = false;
            this.runCommand();
            GlobalDefine.PAUSE_DEBUG = true;
        }
        catch (Exception e2) {
            if (GlobalDefine.DEBUG_TRACE) {
                MOut.G(this).println("Exception:");
                e2.printStackTrace();
            } else {
                MOut.G(this).println("Exception:" + e2.getMessage());
            }
            this.statusCode = 148;
            return;
        }
        if (!this.isSessionClosed) {
            b2 = this.sessionController.closeSession();
        }
        GlobalDefine.PAUSE_DEBUG = false;
    }

    public boolean validateForCMM() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (!(IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid))) {
            MOut.G(this).println("This command only supports MicroCMM devices.");
            return false;
        }
        return true;
    }

    public void closeSessionIfExist() {
        if (this.sessionController != null) {
            this.sessionController.closeSession();
        }
    }

    public void createSession() {
        try {
            this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, this.ipmiMicroBladeOEMCommand);
        }
        catch (IPMIException ex) {
            MOut.G(this).println(ex.getMessage());
            String message = ex.getMessage();
            if (message.indexOf("connect") != -1) {
                this.statusCode = 145;
            } else if (message.indexOf("login") != -1) {
                this.statusCode = 146;
            }
            return;
        }
    }

    public boolean preValidate() {
        return true;
    }

    public abstract void runCommand() throws Exception;
}

