/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeNodeLanDHCPCommand
extends MicroBladeCommand {
    String bladeIndex;
    int nodeIndex = 0;
    byte bIndex = 0;
    int isDHCP = 0;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            if (this.parameters.length >= 3) {
                try {
                    this.isDHCP = Integer.parseInt(this.getParameters()[2]);
                }
                catch (Exception e2) {
                    MOut.G(this).println("The dhcp mode must be either Static:1 or DHCP:2");
                    this.statusCode = 147;
                    return false;
                }
                if (this.isDHCP != 1 && this.isDHCP != 2) {
                    MOut.G(this).println("The dhcp mode must be either Static:1 or DHCP:2");
                    this.statusCode = 147;
                    return false;
                }
            }
            if (this.parameters.length >= 2) {
                try {
                    this.nodeIndex = Integer.parseInt(this.getParameters()[1]);
                }
                catch (Exception e3) {
                    MOut.G(this).println("The node index must be 1-4");
                    return false;
                }
                if (this.nodeIndex < 1 || this.nodeIndex > 4) {
                    MOut.G(this).println("The node index must be 1-4");
                    return false;
                }
            }
            if (this.parameters.length >= 1) {
                this.bladeIndex = this.getParameters()[0];
                this.bIndex = (byte)NodeSensorInfo.getBladeIndex(this.bladeIndex);
                if (this.bIndex < 0) {
                    MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void runCommand() throws Exception {
        if (this.getParameters() == null) {
            MOut.G(this).println("Usage: microBlade node dhcp <bladeID> <nodeID> [static:1 | dhcp:2]");
        } else if (this.getParameters().length == 2) {
            NodeStatusInfo nodeStatusInfo = this.ipmiMicroBladeOEMCommand.getNodeStatus(this.bIndex, (byte)(this.nodeIndex - 1));
            BladeRemoteInfo bladeRemoteInfo = this.ipmiMicroBladeOEMCommand.getBladeRemoteInfo(this.bIndex);
            if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                MOut.G(this).println("Blade " + this.bladeIndex + " Node " + this.nodeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            String s = this.ipmiMicroBladeOEMCommand.getNodeLanDHCP(this.bIndex, this.nodeIndex - 1);
            MOut.G(this).println("IP Mode: " + s);
        } else if (this.getParameters().length == 3) {
            BladeRemoteInfo bladeRemoteInfo = this.ipmiMicroBladeOEMCommand.getBladeRemoteInfo(this.bIndex);
            NodeStatusInfo nodeStatusInfo = this.ipmiMicroBladeOEMCommand.getNodeStatus(this.bIndex, (byte)(this.nodeIndex - 1));
            if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                MOut.G(this).println("Blade " + this.bladeIndex + " Node " + this.nodeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            boolean b2 = this.ipmiMicroBladeOEMCommand.setNodeLanDHCP(this.bIndex, this.nodeIndex - 1, this.isDHCP);
            if (!b2) {
                MOut.G(this).println("Update IP Mode Fail");
                this.sessionController.closeSession();
                return;
            }
            MOut.G(this).println("Update IP Mode Successfully");
        } else {
            MOut.G(this).println("Usage: microBlade node dhcp <bladeID> <nodeID> [static:1 | dhcp:2]");
        }
        this.statusCode = 0;
    }
}

