/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeSwitchLANGatewayCommand
extends MicroBladeCommand {
    byte sIndex = (byte)-1;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            if (this.parameters.length >= 1) {
                String switchIndex = this.getParameters()[0];
                this.sIndex = (byte)SwitchInfo.getIndex(switchIndex);
                if (this.sIndex < 0) {
                    MOut.G(this).println("The switch index must be A1-A2 or B1-B2");
                    return false;
                }
            }
        } else {
            MOut.G(this).println("Usage: microBlade switch lan gateway <switch index> [gateway]");
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void runCommand() throws Exception {
        if (this.getParameters().length == 1) {
            SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch(this.sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                return;
            }
            MOut.G(this).println("Usage: microBlade switch lan gateway <switch index> [gateway]");
            String result = this.ipmiMicroBladeOEMCommand.getSwitchGateway(this.sIndex + 1);
            MOut.G(this).println(this.getParameters()[0].toUpperCase() + " Gateway: " + result);
        } else if (this.getParameters().length == 2) {
            SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch(this.sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                return;
            }
            boolean b2 = this.ipmiMicroBladeOEMCommand.setSwitchGateway(this.sIndex + 1, this.getParameters()[1]);
            if (!b2) {
                MOut.G(this).println("Update Gateway Fail");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Update Gateway Successfully");
        } else {
            MOut.G(this).println("Usage: microBlade switch lan gateway <switch index> [gateway]");
        }
        this.statusCode = 0;
    }
}

