/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeSwitchUsernameCommand
extends MicroBladeCommand {
    byte sIndex = (byte)-1;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            if (this.parameters.length >= 1) {
                String switchIndex = this.getParameters()[0];
                this.sIndex = (byte)SwitchInfo.getIndex(switchIndex);
                if (this.sIndex < 0) {
                    MOut.G(this).println("The switch index must be A1-A2 or B1-B2");
                    return false;
                }
            }
        } else {
            MOut.G(this).println("Usage: microBlade switch username <switch index> [Username]");
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void runCommand() throws Exception {
        if (this.getParameters().length == 1) {
            SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch(this.sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                return;
            }
            MOut.G(this).println("Usage: microBlade switch username <switch index> [Username]");
            String result = this.ipmiMicroBladeOEMCommand.getSwitchUsername(this.sIndex + 1);
            MOut.G(this).println(this.getParameters()[0].toUpperCase() + " Username: " + result);
        } else if (this.getParameters().length == 2) {
            SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch(this.sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                return;
            }
            boolean b2 = this.ipmiMicroBladeOEMCommand.setSwitchUsername(this.sIndex + 1, this.getParameters()[1]);
            if (!b2) {
                MOut.G(this).println("Update Username Fail");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Update Username Successfully");
        } else {
            MOut.G(this).println("Usage: microBlade switch username <switch index> [Username]");
        }
        this.statusCode = 0;
    }
}

