/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIDCMICommand;
import com.supermicro.ipmi.nm.dcmi.EnhancedPowerStatAttr;
import com.supermicro.ipmi.nm.dcmi.GetPowerReading;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20DCMIGetPowerReading
extends NM20AbstractCommand {
    private int mode;
    private byte period;
    private IPMIDCMICommand dcmi;
    private GetPowerReading command;

    @Override
    public boolean preValidate() {
        try {
            if (this.parameters == null || this.parameters.length == 0) {
                this.help();
                return false;
            }
            this.mode = Integer.parseInt(this.parameters[0]);
            if (this.mode == 1 && this.parameters.length == 1) {
                return true;
            }
            if (this.mode == 2 && this.parameters.length == 2) {
                this.period = (byte)Integer.parseInt(this.parameters[1], 16);
                return true;
            }
            this.help();
            return false;
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return false;
        }
    }

    @Override
    public void runNM20Command() throws Exception {
        try {
            this.dcmi = new IPMIDCMICommand(this.ipmiInterfaceForNM);
            this.command = new GetPowerReading(this.dcmi);
            if (this.mode == 1) {
                IPMIDCMICommand.DCMIPowerReading powerStatus = this.command.execute((byte)this.mode, (byte)0);
                MOut.G(this).println(powerStatus.toFormatedString());
            } else {
                IPMIDCMICommand.DCMIPowerReading powerStatus = this.command.execute((byte)this.mode, this.period);
                MOut.G(this).println(powerStatus.toFormatedString(EnhancedPowerStatAttr.getTimeDuration(this.period), EnhancedPowerStatAttr.getTimeUnit(this.period)));
            }
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
        }
    }

    private void help() {
        MOut.G(this).println("powerReading <mode> [<period>]");
        MOut.G(this).println("mode:");
        MOut.G(this).println("\t 1 \u00a1V System Power Statistics");
        MOut.G(this).println("\t 2 \u00a1V Enhanced System Power Statistics");
        MOut.G(this).println("period (hex): Rolling average time period.");
        MOut.G(this).println("\t For mode=2, use \"nm20 dcmi cap\" to get supported value.");
    }
}

