/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.nm.SetNodeManagerPolicyAlertThreasholds;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20SetAlertThresholdCommand
extends NM20AbstractCommand {
    private int domainId;
    private int policyId;
    private int count;
    private int[] thresholds;
    private byte[] thresholdsInBytes;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 3 || this.parameters.length > 6) {
            this.help();
            return false;
        }
        try {
            this.domainId = Integer.parseInt(this.parameters[0]);
            this.policyId = Integer.parseInt(this.parameters[1]);
            this.count = Integer.parseInt(this.parameters[2]);
            if (this.count < 0 || this.count > 3 || this.domainId < 0 || this.policyId < 0 || this.policyId > 255) {
                this.help();
                return false;
            }
            if (this.count != this.parameters.length - 3) {
                MOut.G(this).println("Please input correct count");
                return false;
            }
            this.thresholds = new int[this.count];
            if (this.count != 0) {
                for (int i2 = 3; i2 < 3 + this.count; ++i2) {
                    int th = Integer.parseInt(this.parameters[i2]);
                    if (th < 0 || th > Short.MAX_VALUE) {
                        this.help();
                        return false;
                    }
                    this.thresholds[i2 - 3] = th;
                }
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void runNM20Command() throws Exception {
        try {
            if (this.count != 0) {
                this.thresholdsInBytes = new byte[this.count * 2];
                for (int i2 = 0; i2 < this.count; ++i2) {
                    ByteUtility.intTo2Bytes(this.thresholdsInBytes, i2 * 2, this.thresholds[i2]);
                }
            } else {
                this.thresholdsInBytes = new byte[0];
            }
            SetNodeManagerPolicyAlertThreasholds command = new SetNodeManagerPolicyAlertThreasholds(this.ipmiNM20Command, (byte)this.domainId, (byte)this.policyId, this.count, this.thresholdsInBytes);
            command.execute();
            MOut.G(this).println("Done");
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 148;
        }
    }

    private void help() {
        MOut.G(this).println("setAlertThreshold <domainId> <policyId> <count> [<th0> <th1> <th2>]");
        MOut.G(this).println("domainId:");
        MOut.G(this).println("\t0 \u00a1V Entire platform");
        MOut.G(this).println("\t1 \u00a1V CPU subsystem");
        MOut.G(this).println("\t2 \u00a1V Memory subsystem");
        MOut.G(this).println("\t3 \u00a1V HW Protection (NM3.0)");
        MOut.G(this).println("\t4 \u00a1V High Power I/O subsystem");
        MOut.G(this).println("policyId: 0~255");
        MOut.G(this).println("count:");
        MOut.G(this).println("\t0   - Clear all thresholds");
        MOut.G(this).println("\t1~3 - Number of alert thresholds");
        MOut.G(this).println("th0~th1: threshold value");
    }
}

