/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.cups.CUPSPolicyParam;
import com.supermicro.ipmi.nm.cups.GetCUPSPolicy;
import com.supermicro.ipmi.nm.cups.SetCUPSPolicy;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM30AbstractCommand;

public class NM30CUPSPolicyControl
extends NM30AbstractCommand {
    private final int targetId = 1;
    private int enable;
    private int domainId;

    public NM30CUPSPolicyControl(int enable) {
        this.enable = enable;
    }

    @Override
    public boolean preValidate() {
        try {
            if (this.parameters == null || this.parameters.length != 1) {
                this.help();
                return false;
            }
            this.domainId = Integer.parseInt(this.parameters[0]);
            if (this.domainId != 1 && this.domainId != 2 && this.domainId != 4) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print("Invalid value: " + ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void runNM30Command() throws Exception {
        try {
            GetCUPSPolicy command = new GetCUPSPolicy(this.ipmiNM20Command, this.domainId, 1);
            IPMINM20Command.CUPSPolicy policy = command.execute();
            this.setPolicy(policy);
            MOut.G(this).println("Done.");
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
        }
    }

    private void setPolicy(IPMINM20Command.CUPSPolicy policy) throws IPMIException {
        CUPSPolicyParam param = new CUPSPolicyParam((byte)this.domainId, 1, (byte)this.enable, policy.policyType, policy.policyAction, policy.cupsThreshold, policy.avgWindowInSec);
        new SetCUPSPolicy(this.ipmiNM20Command, param).execute();
    }

    private void help() {
        if (this.enable == 1) {
            MOut.G(this).println("enableCupsPolicy <domainId>");
        } else {
            MOut.G(this).println("disableCupsPolicy <domainId>");
        }
        MOut.G(this).println("domainId:");
        MOut.G(this).println("\t1 \u00a1V Core Domain");
        MOut.G(this).println("\t2 \u00a1V Memory Domain");
        MOut.G(this).println("\t4 \u00a1V IO Domain");
    }
}

