/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMITASCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;
import java.util.Collections;

public class NVMEIBSmartInfoCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        int i2;
        IPMITASCommand ipmiTasCommand = new IPMITASCommand(null);
        ipmiTasCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (!ipmiTasCommand.checkTASAlive()) {
            this.statusCode = 0;
            return;
        }
        int deviceCount = ipmiTasCommand.getNVMEDeviceCount();
        if (deviceCount == 0) {
            MOut.G().println("No NVME devices.");
            this.statusCode = 0;
            return;
        }
        ArrayList<IPMITASCommand.SmartInfo> list = new ArrayList<IPMITASCommand.SmartInfo>();
        String result = new String();
        for (i2 = 0; i2 < deviceCount; ++i2) {
            int offset = 0;
            int lengthCount = 0;
            byte currentLength = 0;
            int TotalLength = ipmiTasCommand.getSmartTotalDataLength(i2);
            do {
                byte[] data = ipmiTasCommand.getSmartRetunInfo(i2, offset);
                currentLength = data[6];
                byte[] smartInfo = new byte[currentLength];
                System.arraycopy(data, 7, smartInfo, 0, currentLength);
                offset += 32;
                result = result + new String(smartInfo);
            } while ((lengthCount += currentLength) < TotalLength);
            if (result.indexOf(";18:") == -1) {
                MOut.G().println("Command abort due to TAS update, please try again");
                this.statusCode = 0;
                return;
            }
            list.add(ipmiTasCommand.createSmartStructure(result));
            result = "";
        }
        Collections.sort(list);
        if (this.parameters == null) {
            for (i2 = 0; i2 < deviceCount; ++i2) {
                MOut.G(this).println(((IPMITASCommand.SmartInfo)list.get(i2)).toFormatedHeader() + ((IPMITASCommand.SmartInfo)list.get(i2)).toFormatedString());
            }
        } else if (this.parameters != null && this.parameters.length == 1) {
            for (i2 = 0; i2 < deviceCount; ++i2) {
                if (!this.parameters[0].equalsIgnoreCase(((IPMITASCommand.SmartInfo)list.get((int)i2)).name)) continue;
                MOut.G(this).println(((IPMITASCommand.SmartInfo)list.get(i2)).toFormatedHeader() + ((IPMITASCommand.SmartInfo)list.get(i2)).toFormatedString());
                this.statusCode = 0;
                return;
            }
            MOut.G().println("Can't find device name.");
        } else {
            MOut.G(this).println("Usage: nvmeIB smartInfo [HDD Name]");
        }
        this.statusCode = 0;
    }
}

