/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMINVMECommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class NVMEInsertSSDCommand
extends SuperBladeCommand {
    byte aoc;
    byte slot;
    byte group;

    @Override
    public boolean preValidate() {
        this.aoc = 0;
        this.slot = 0;
        this.group = 0;
        if (this.parameters == null || this.parameters.length < 3) {
            MOut.G(this).println("Usage: nvme insert <aoc> <group> <slot>");
            this.statusCode = 147;
            return false;
        }
        try {
            this.aoc = Byte.parseByte(this.parameters[0], 10);
        }
        catch (NumberFormatException e2) {
            MOut.G(this).println(e2.getMessage());
            this.statusCode = 147;
            return false;
        }
        try {
            this.group = Byte.parseByte(this.parameters[1], 10);
        }
        catch (NumberFormatException e3) {
            MOut.G(this).println(e3.getMessage());
            this.statusCode = 147;
            return false;
        }
        try {
            this.slot = Byte.parseByte(this.parameters[2], 10);
        }
        catch (NumberFormatException e4) {
            MOut.G(this).println(e4.getMessage());
            this.statusCode = 147;
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        ArrayList<IPMINVMECommand.NVMEAOCInfo> nvmeAOCInfos;
        IPMINVMECommand ipmiNVMECommand = new IPMINVMECommand(null);
        ipmiNVMECommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ipmiOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] productID = ipmiOEMCommand.getProductID();
        if (IPMIOEMCommand.getBoardModel(productID).contains("X11OP")) {
            this.group = (byte)(this.group - 1);
        }
        boolean nongroup = false;
        byte[] dropGroupStatus = null;
        try {
            dropGroupStatus = ipmiNVMECommand.getDropGroupStatus();
            if (dropGroupStatus[0] == 1) {
                nongroup = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nongroup) {
            if (!ipmiNVMECommand.isEjected(this.slot, dropGroupStatus, nongroup)) {
                MOut.G(this).println("This device has been inserted already");
                return;
            }
        } else {
            byte[] raw = ipmiNVMECommand.getEjectFlagArray(this.aoc, this.group);
            if (!ipmiNVMECommand.isEjected(this.slot, raw, nongroup)) {
                MOut.G(this).println("This device has been inserted already");
                return;
            }
        }
        if ((nvmeAOCInfos = ipmiNVMECommand.getAll()) == null) {
            this.statusCode = 153;
            MOut.G(this).println("No NVME info");
            return;
        }
        if (nongroup) {
            ipmiNVMECommand.setLocate((byte)-1, this.slot, (byte)2, (byte)-1);
            MOut.G(this).println("Done");
            this.statusCode = 0;
            return;
        }
        if (!IPMIOEMCommand.getBoardModel(productID).contains("X11OP")) {
            this.slot = nvmeAOCInfos.get((int)0).aocGroups.get((int)0).slotPerGroup == 24 ? (byte)(this.slot % 24) : (byte)(this.slot % 12);
        }
        ipmiNVMECommand.setLocate(this.aoc, this.slot, (byte)2, this.group);
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

