/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMINVMECommand;
import com.supermicro.ipmi.text.LicenseManager;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NVMESetVPDCommand
extends SuperBladeCommand {
    byte aoc;
    byte slot;
    byte group;

    @Override
    public boolean preValidate() {
        this.aoc = 0;
        this.slot = 0;
        this.group = 0;
        if (this.parameters == null || this.parameters.length < 4) {
            MOut.G(this).println("Usage: nvme setVPD <aoc> <group> <slot> <fileName>");
            return false;
        }
        try {
            this.aoc = Byte.parseByte(this.parameters[0], 10);
        }
        catch (NumberFormatException e2) {
            MOut.G(this).println(e2.getMessage());
            return false;
        }
        try {
            this.group = Byte.parseByte(this.parameters[1], 10);
        }
        catch (NumberFormatException e3) {
            MOut.G(this).println(e3.getMessage());
            return false;
        }
        try {
            this.slot = Byte.parseByte(this.parameters[2], 10);
        }
        catch (NumberFormatException e4) {
            MOut.G(this).println(e4.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        LicenseManager lm = new LicenseManager(this.ipmiCMMOEMCommand.getIPMIInterface(), this.config);
        if (!lm.checkIfDCMSLicenseExist()) {
            MOut.G(this).println("License DCMS-Single needs to be activated");
            this.statusCode = 155;
            return;
        }
        IPMINVMECommand ipmiNVMECommand = new IPMINVMECommand(null);
        ipmiNVMECommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte currentStatus = ipmiNVMECommand.getNVMEVPDWriteStatus();
        if (currentStatus != 0 && currentStatus != 2 && currentStatus != 3) {
            MOut.G(this).println("NVME VPD writing status is not ready");
            this.statusCode = 0;
            return;
        }
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiNVMECommand.assignVPDparameters(this.aoc, this.group, this.slot);
        boolean result = ipmiBMCFileCommand.generalFileUpload((byte)17, this.parameters[3]);
        if (result) {
            MOut.G(this).println("Updating..");
            for (int count = 0; count < 10; ++count) {
                Thread.sleep(2000L);
                currentStatus = ipmiNVMECommand.getNVMEVPDWriteStatus();
                if (currentStatus == 1) {
                    Thread.sleep(2000L);
                    continue;
                }
                if (currentStatus == 3) {
                    this.statusCode = 149;
                    MOut.G(this).println("Update VPD file failed");
                    return;
                }
                this.statusCode = 0;
                MOut.G(this).println("Done");
                return;
            }
        } else {
            this.statusCode = 149;
            MOut.G(this).println("Upload VPD file failed");
            return;
        }
    }
}

