/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;

public class OEMBladeAllSELCommand
extends SuperBladeCommand {
    String filename;

    public OEMBladeAllSELCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Please specify filename");
            return false;
        }
        this.filename = this.parameters[0];
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        int bladeSize = guid[8];
        String[] bladeIPs = new String[bladeSize];
        MOut.G(this).println("Getting Blade IP ...");
        for (int i2 = 0; i2 < bladeSize; ++i2) {
            String ip = null;
            try {
                bladeIPs[i2] = ip = this.showSIMBLIP((byte)(i2 + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i3 = 0; i3 < bladeSize; ++i3) {
            if (bladeIPs[i3] == null) continue;
            try {
                String bladeSEL = this.getBladeSEL((byte)(i3 + 1), bladeIPs[i3], this.config.getUserName(), this.config.getPassword());
                sb.append(bladeSEL);
                this.saveSELtoFile(this.filename, sb.toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.statusCode = 0;
    }

    public void saveSELtoFile(String filename, String sel) throws Exception {
        FileWriter fw = new FileWriter(filename);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(sel);
        bw.close();
        fw.close();
    }

    public String getBladeSEL(byte bladeIndex, String bladeIP, String ID2, String PW) throws Exception {
        StringBuffer sb = new StringBuffer();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(bladeIP);
        config.setUserName(ID2);
        config.setPassword(PW);
        config.setPrivilege((byte)4);
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiSELCommand);
        if (sessionController == null) {
            throw new IPMIException("Cannot create session");
        }
        ipmiSDRCommand.setIPMIInterface(ipmiSELCommand.getIPMIInterface());
        ipmiOEMCommand.setIPMIInterface(ipmiSELCommand.getIPMIInterface());
        try {
            byte[] productID = ipmiOEMCommand.getProductID();
            if (productID == null) {
                productID = new byte[2];
            }
            MOut.G(this).println("Getting Blade " + bladeIndex + "(" + bladeIP + ") SDR/SEL ...");
            SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
            SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
            ArrayList list = ipmiSELCommand.getSELEntries(selInfo.getLogEntries());
            int count = 0;
            if (list.size() != 0) {
                for (SELRecord item : list) {
                    ArrayList raw = new ArrayList();
                    sb.append("Blade " + bladeIndex);
                    sb.append("," + (count + 1));
                    sb.append("," + ByteUtility.fourByteToDateFormat2(item.getTimeStamp()));
                    sb.append("," + GlobalDefine.getSensorType(item.getSensorType() & 0xFF));
                    if (this.parameters != null && this.parameters.length >= 1 && this.parameters[0].equals("-v")) {
                        System.out.println(item.toString());
                    }
                    if ((item.getSensorType() & 0xFF) >= 193 && (item.getSensorType() & 0xFF) <= 197) {
                        sb.append(GlobalDefine.getSensorType(item.getSensorType() & 0xFF) + " " + (byte)(item.getSensorNumber() & 0xFF));
                    } else {
                        Object sensorName = SDRRecord.sensorNumberToSensorName.get("" + (item.getSensorNumber() & 0xFF));
                        if (sensorName != null) {
                            sb.append("," + sensorName.toString());
                        } else {
                            sb.append(",");
                        }
                    }
                    String reading = "";
                    if (item.getEventType() == 1) {
                        byte offset = item.getEventData1();
                        double readingValue = ((SDRRecord)SDRRecord.sensorNumberToSDRRecord.get("" + (item.getSensorNumber() & 0xFF))).calSensorReading(item.getEventData2() & 0xFF);
                        double threshold = ((SDRRecord)SDRRecord.sensorNumberToSDRRecord.get("" + (item.getSensorNumber() & 0xFF))).calSensorReading(item.getEventData3() & 0xFF);
                        if (item.getSensorType() == 4) {
                            reading = reading + ",Reading = " + (int)readingValue + " RPM (Threshold = " + (int)threshold + " RPM)";
                        } else if (item.getSensorType() == 2) {
                            reading = reading + ",Reading = " + String.format("%3.2f", readingValue) + " V (Threshold = " + String.format("%3.2f", threshold) + " V)";
                        } else if (item.getSensorType() == 1) {
                            reading = reading + ",Reading = " + String.format("%3.2f", readingValue) + " C (Threshold = " + String.format("%3.2f", threshold) + " C)";
                        }
                    }
                    sb.append("," + GlobalDefine.getEventType((byte)(item.getEventDir() | item.getEventType()), item.getSensorType(), item.getEventData1(), item.getEventData2(), item.getEventData3(), productID) + reading);
                    sb.append("\n");
                    ++count;
                }
                sessionController.closeSession();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public String showSIMBLIP(byte bladeIndex) throws Exception {
        String ip = null;
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmb.setChannel(bladeIndex);
        if (this.sessionController != null && (ip = ipmiLanCommand.getIP()) != null) {
            return ip;
        }
        throw new IPMIException("IPMB error");
    }
}

