/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class PMBusInfoCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmiI2CPMBusCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte busID = 0;
        byte slaveAddr = 0;
        if (this.parameters == null) {
            ipmiI2CPMBusCommand.detectBusID();
            ipmiI2CPMBusCommand.isUseOEMPsuCmd = ipmiI2CPMBusCommand.checkOEMGetPSUInfoCommand();
            if (ipmiI2CPMBusCommand.isUseOEMPsuCmd) {
                ipmiI2CPMBusCommand.detectSlaveAddressWithPsuIndex();
            } else {
                ipmiI2CPMBusCommand.detectSlaveAddress();
            }
            if (ipmiI2CPMBusCommand.getBusID() == 0) {
                MOut.G(this).println("Cannot detect BusID");
                this.statusCode = 151;
                return;
            }
            if (ipmiI2CPMBusCommand.getAvailableSlaveAddrs() == null) {
                MOut.G(this).println("Cannot detect slave address");
                this.statusCode = 151;
                return;
            }
            for (int i2 = 0; i2 < ipmiI2CPMBusCommand.getAvailableSlaveAddrs().length; ++i2) {
                String moduleLabel = "";
                int module = ipmiI2CPMBusCommand.getModule(ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i2]);
                if (module != 0) {
                    moduleLabel = "[Module " + module + "]";
                }
                if (ipmiI2CPMBusCommand.getAvailablePsuIndexs() != null) {
                    moduleLabel = "[Module " + Integer.parseInt(ByteUtility.byteToHex(ipmiI2CPMBusCommand.getAvailablePsuIndexs()[i2]), 10) + "]";
                    if (ipmiI2CPMBusCommand.isUseOEMPsuCmd) {
                        MOut.G(this).println(moduleLabel);
                    } else {
                        MOut.G(this).println(" [SlaveAddress = " + ByteUtility.byteToHex(ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i2]) + "h] " + moduleLabel);
                    }
                } else {
                    MOut.G(this).println(" [SlaveAddress = " + ByteUtility.byteToHex(ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i2]) + "h] " + moduleLabel);
                }
                ipmiI2CPMBusCommand.setSlaveAddr(ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i2]);
                if (ipmiI2CPMBusCommand.getAvailablePsuIndexs() != null) {
                    ipmiI2CPMBusCommand.setPsuIndex(ipmiI2CPMBusCommand.getAvailablePsuIndexs()[i2]);
                }
                IPMII2CPMBusCommand.PMBusHealth pmBusHealth = ipmiI2CPMBusCommand.getAll();
                MOut.G(this).println(pmBusHealth.toFormatedHeader() + pmBusHealth.toFormatedString());
            }
        } else {
            if (this.parameters.length < 2) {
                MOut.G(this).println("[<busId> <SlaveAddr>] both parameters required");
                this.statusCode = 147;
                return;
            }
            try {
                busID = (byte)Integer.parseInt(this.parameters[0], 16);
                slaveAddr = (byte)Integer.parseInt(this.parameters[1], 16);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            ipmiI2CPMBusCommand.setBusID(busID);
            ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
            IPMII2CPMBusCommand.PMBusHealth pmBusHealth = ipmiI2CPMBusCommand.getAll();
            MOut.G(this).println(pmBusHealth.toFormatedHeader() + pmBusHealth.toFormatedString());
        }
        this.statusCode = 0;
    }
}

