/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class RT2FanCommand
extends SuperBladeCommand {
    byte levelStep = (byte)10;

    public void printUsage() {
        MOut.G(this).println("Usage: rt2fan <low limit> <high limit>");
        this.statusCode = 147;
    }

    @Override
    public void runCommand() throws Exception {
        String formatTemplate = "IP:%-16s RT1:%-3s RT2:%-3s Diff:%-3s FanLevel:%-12s";
        int lowLimit = 0;
        int highLimit = 0;
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] allTemp = ipmiAMIOEMCommand.getAllTemperature();
        byte[] allFanLevel = ipmiAMIOEMCommand.getPWM();
        byte rt1 = allTemp[2];
        byte rt2 = allTemp[3];
        int delta = Math.abs(rt2 - rt1);
        if (this.parameters != null && this.parameters.length < 2) {
            this.printUsage();
            return;
        }
        if (this.parameters == null) {
            String s = String.format(formatTemplate, this.config.getIp(), rt1, rt2, delta, ByteUtility.bytesToHex(allFanLevel));
            MOut.G(this).println(s);
            return;
        }
        try {
            lowLimit = Integer.parseInt(this.parameters[0]);
            highLimit = Integer.parseInt(this.parameters[1]);
        }
        catch (Exception e2) {
            MOut.G(this).println(e2.getMessage());
            this.statusCode = 147;
            return;
        }
        if (this.parameters.length > 2) {
            try {
                this.levelStep = (byte)Integer.parseInt(this.parameters[2]);
            }
            catch (Exception e3) {
                MOut.G(this).println(e3.getMessage());
                this.statusCode = 147;
                return;
            }
        }
        int newFanLevel = allFanLevel[0] & 0xFF;
        boolean isSetFanLevel = false;
        if (delta >= highLimit) {
            isSetFanLevel = true;
            if ((newFanLevel += this.levelStep) > 255) {
                newFanLevel = 255;
            }
            if (newFanLevel == 255 && (allFanLevel[0] & 0xFF) == 255) {
                isSetFanLevel = false;
            }
        }
        if (delta <= lowLimit) {
            isSetFanLevel = true;
            if ((newFanLevel -= this.levelStep) <= 0) {
                newFanLevel = 0;
            }
            if (newFanLevel == 0 && (allFanLevel[0] & 0xFF) == 0) {
                isSetFanLevel = false;
            }
        }
        if (isSetFanLevel) {
            ipmiAMIOEMCommand.setPWM((byte)0, (byte)newFanLevel);
            ipmiAMIOEMCommand.setPWM((byte)1, (byte)newFanLevel);
            ipmiAMIOEMCommand.setPWM((byte)2, (byte)newFanLevel);
            ipmiAMIOEMCommand.setPWM((byte)3, (byte)newFanLevel);
        }
        if (rt1 > rt2) {
            byte t = rt1;
            rt1 = rt2;
            rt2 = t;
        }
        if (isSetFanLevel) {
            byte[] allFanLevel2 = ipmiAMIOEMCommand.getPWM();
            String s = String.format(formatTemplate, this.config.getIp(), rt1, rt2, delta, ByteUtility.bytesToHex(allFanLevel)) + "NewFanLevel:" + ByteUtility.bytesToHex(allFanLevel2);
            MOut.G(this).println(s);
        } else {
            String s = String.format(formatTemplate, this.config.getIp(), rt1, rt2, delta, ByteUtility.bytesToHex(allFanLevel));
            MOut.G(this).println(s);
        }
    }
}

