/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.stunnel.StunnelParameterBuilder;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.vstorage.VirtualStorage;

public class RemoteKeyboardOperationIKVMCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("No keyboard operation file path");
            MOut.G(this).println("");
            MOut.G(this).println(RemoteKeyboardOperationIKVMCommand.help().toString());
            this.statusCode = 147;
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        boolean isForceStunnelVer11 = false;
        if (!this.isATENKVMSupported()) {
            this.printUnavailableMessage();
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        String jarDir = RemoteKeyboardOperationIKVMCommand.getJarPath(this.getClass()) + File.separator;
        File f2 = new File(jarDir + "ko.jar");
        if (!f2.exists()) {
            MOut.G(this).println("Cannot find ko.jar");
            this.statusCode = 149;
            return;
        }
        String params = "";
        if (this.getParameters() != null) {
            for (int i2 = 0; i2 < this.getParameters().length; ++i2) {
                if ("ssl".equalsIgnoreCase(this.getParameters()[i2])) {
                    isForceStunnelVer11 = true;
                    break;
                }
                params = params + " " + this.getParameters()[i2];
            }
        }
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        int stunnelVer = 0;
        try {
            stunnelVer = ipmiOEMPortServiceCommand.getPort((byte)15);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean isIPv6 = false;
        String ip = this.config.getIp();
        if (stunnelVer > 0) {
            IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
            ipmiSELCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            String selTime = ipmiSELCommand.getSELTimeWithFormat();
            StunnelUtility.validateSELwithCertifcateTime(selTime, stunnelVer);
            if (isForceStunnelVer11) {
                stunnelVer = 11;
            } else if (stunnelVer == 13) {
                stunnelVer = 11;
            }
            StunnelParameters parameters = null;
            MOut.G(this).println("This device support stunnel.");
            try {
                byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
                parameters = StunnelParameterBuilder.runByFunction(stunnelVer, ip, this.config.getUserName(), this.config.getPassword(), ipmiOEMPortServiceCommand, guid, "ko");
                if (parameters == null) {
                    this.statusCode = 149;
                    return;
                }
                if (parameters.getUser() != null && parameters.getUser().isKVMSessionConnected()) {
                    this.statusCode = 149;
                    return;
                }
            }
            catch (Exception e2) {
                MOut.G(this).println(e2.getMessage());
                this.statusCode = 149;
                return;
            }
            try {
                if (stunnelVer == 5) {
                    StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), parameters.getCAMode());
                    InfoRepository infoRepository = InfoRepository.createInfoRepository(parameters.getStunnelIP(), this.config.getUserName(), this.config.getPassword(), parameters.getSturnnlPortList().get(0), 623);
                    if (!VirtualStorage.loadLibraryAndValidateUser(stunnelVer, infoRepository)) {
                        StunnelUtility.stopStunnel(parameters.getStunnelFolder());
                        stunnelVer = 11;
                        parameters = StunnelParameterBuilder.runByFunction(stunnelVer, ip, this.config.getUserName(), this.config.getPassword(), ipmiOEMPortServiceCommand, null, "ko");
                        StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), parameters.getCAMode());
                    }
                } else {
                    StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), parameters.getCAMode());
                }
                String userName = this.config.getUserName();
                String password = this.config.getPassword();
                if (parameters.getUser() != null) {
                    userName = parameters.getUser().getUsername();
                    password = parameters.getUser().getPassword();
                }
                this.startKeyboardOperation(jarDir, parameters.getStunnelIP(), parameters.getSturnnlPort(), userName, password, params, parameters.getStunnelFolder(), ip, stunnelVer);
            }
            catch (Exception e3) {
                MOut.G(this).println("Config stunnel or start stunnel fail");
            }
        } else {
            int port = 5900;
            try {
                port = ipmiOEMPortServiceCommand.getPort((byte)2);
            }
            catch (IPMIException e4) {
                port = 5900;
            }
            this.startKeyboardOperation(jarDir, ip, this.config.getUserName(), this.config.getPassword(), params, port);
        }
    }

    public void startKeyboardOperation(String jarDir, String ip, String id, String pw, String params, String token) {
        this.startKeyboardOperation(jarDir, ip, id, pw, params, 5900);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startKeyboardOperation(String jarDir, String ip, String port, String id, String pw, String params, String stunnleFolder, String BMCIP, int stunnelVer) {
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " --port" + port + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer : "./jre/bin/java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " --port" + port + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer) : "java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " --port" + port + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer;
        BufferedReader br = null;
        InputStreamReader isr = null;
        InputStream stdin = null;
        try {
            Process p = Runtime.getRuntime().exec(execString);
            stdin = p.getInputStream();
            isr = new InputStreamReader(stdin);
            br = new BufferedReader(isr);
            String line = null;
            String OS = StunnelUtility.checkOS();
            while ((line = br.readLine()) != null) {
                if (OS.indexOf("Windows") <= -1) continue;
                MOut.G(this).println(line);
                return;
            }
            p.waitFor();
            this.statusCode = p.exitValue();
            MOut.G(this).println("Done");
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed");
            this.statusCode = 149;
            return;
        }
        catch (Exception e2) {
            MOut.G(this).println(" Failed " + e2);
            this.statusCode = 149;
            return;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void startKeyboardOperation(String jarDir, String ip, String id, String pw, String params, int port) {
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " --kvmport" + port : "./jre/bin/java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " --kvmport" + port) : "java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " --kvmport" + port;
        try {
            Process p = Runtime.getRuntime().exec(execString);
            p.waitFor();
            this.statusCode = p.exitValue();
            MOut.G(this).println("Done");
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed");
            this.statusCode = 149;
            return;
        }
        catch (Exception e2) {
            MOut.G(this).println(" Failed " + e2);
            this.statusCode = 149;
            return;
        }
    }

    private static StringBuffer help() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ============================================================================\n");
        sb.append(" |                     Remote Keyboard Operation Help                       |\n");
        sb.append(" ============================================================================\n");
        sb.append(" Keyboard Operation Parameters List\n");
        sb.append(" ----------------------------------\n");
        sb.append(" Alphanumeric Keys : A-Z, a-z, 0-9, Symbols Keys (example: ,./!#%& ... etc)\n");
        sb.append(" Modifier Keys     : [Shift], [Ctrl], [Alt], [Win]\n");
        sb.append(" Navigation Keys   : [Up], [Down], [Left], [Right], [PageUp], [PageDown],\n");
        sb.append("                     [Home], [End]\n");
        sb.append(" Editing Keys      : [Enter], [Backspace], [Insert], [Delete], [Tab], [Space]\n");
        sb.append(" Miscellaneous Keys: [PrtSc], [Pause], [Esc], [F1]-[F12]\n");
        sb.append(" Macro Key example : [Ctrl+Alt+Delete], [Alt+F4], [Ctrl+v] ... etc\n");
        sb.append(" Delay Parameter   : [Delay=?h?m?s], [Delay=?m?s], [Delay=?s]\n");
        sb.append("\n");
        sb.append("\n");
        sb.append(" Keyboard Operation File Sample\n");
        sb.append(" ------------------------------\n");
        sb.append(" [Ctrl+Alt+Delete][Delay=5s]\n");
        sb.append(" password[Enter][Delay=10s]\n");
        sb.append(" cmd[Enter][Delay=1s]\n");
        sb.append(" ipconfig[Enter]\n");
        return sb;
    }

    public void printUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device.");
    }

    public boolean isATENKVMSupported() {
        boolean result = true;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            result = false;
        } else if (IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isOfficeBladeCMMGUID(guid) || IPMIMessagingCommand.isTwinBladeCMMGUID(guid) || IPMIMessagingCommand.isNormalBladeCMMGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isOSAGUID(guid) || IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isAMIAspeedGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isCB3GUID(guid) || IPMIMessagingCommand.isAMIOnBoardGUID(guid) || IPMIMessagingCommand.isAMIAddOnGUID(guid) || IPMIMessagingCommand.isRenesasATENGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
            result = false;
        }
        return result;
    }

    public static String getT(String ip) {
        byte[] result = null;
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f2 = new SimpleDateFormat("yyyyMMdd");
        String dateShortString = f2.format(date);
        byte[] key = dateShortString.getBytes();
        byte[] plainText = ip.getBytes();
        try {
            Mac hmacMD5 = Mac.getInstance("HmacMD5");
            SecretKeySpec sks = new SecretKeySpec(key, "HmacMD5");
            hmacMD5.init(sks);
            result = hmacMD5.doFinal(plainText);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (result != null) {
            return ByteUtility.bytesToHexNoSpace(result);
        }
        return "";
    }
}

