/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.EventListCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class SELListCommand
extends SuperBladeCommand {
    boolean isIPMI = false;
    EventListCommand eventListRange = new EventListCommand();

    @Override
    public boolean preValidate() {
        this.isIPMI = false;
        this.eventListRange.reset();
        if (this.parameters != null) {
            for (int idx = 0; idx < this.parameters.length; ++idx) {
                if (this.parameters[idx].equals("--ipmi")) {
                    this.isIPMI = true;
                    continue;
                }
                if (idx == this.parameters.length - 1) continue;
                if (this.parameters[idx].equals("-y")) {
                    if (this.eventListRange.setOffsetYear(this.parameters[idx + 1])) continue;
                    MOut.G(this).println("Parameter behind -y should be a positive integer.");
                    return false;
                }
                if (this.parameters[idx].equals("-m")) {
                    if (this.eventListRange.setOffsetMonth(this.parameters[idx + 1])) continue;
                    MOut.G(this).println("Parameter behind -m should be a positive integer.");
                    return false;
                }
                if (!this.parameters[idx].equals("-d") || this.eventListRange.setOffsetDay(this.parameters[idx + 1])) continue;
                MOut.G(this).println("Parameter behind -d should be a positive integer.");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isHGIMEZZGUID(guid) || this.isIPMI) {
            IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
            IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            ipmiSELCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmiSDRCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmiOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            byte[] productID = ipmiOEMCommand.getProductID();
            if (productID == null) {
                productID = new byte[2];
            }
            MOut.G(this).println("Getting SDR records ...");
            SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            ArrayList sensorList = ipmiSDRCommand.getSDRsEx(sdrInfo.getRecordCount());
            boolean isMultipleCPU = true;
            for (int i2 = 0; i2 < sensorList.size(); ++i2) {
                SDRRecord sdr = (SDRRecord)sensorList.get(i2);
                if (!sdr.getSensorName().equalsIgnoreCase("CPU Temp")) continue;
                isMultipleCPU = false;
            }
            SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
            MOut.G(this).println("Getting SEL records ...");
            ArrayList list = ipmiSELCommand.getSELEntries(selInfo.getLogEntries());
            int count = 0;
            String datetimeFormat = "yyyy-MM-dd HH:mm:ss";
            if (list.size() != 0) {
                for (SELRecord item : list) {
                    ArrayList raw = new ArrayList();
                    ++count;
                    String datetime = ByteUtility.fourByteToDateFormatSpecific(item.getTimeStamp(), "yyyy-MM-dd HH:mm:ss");
                    if (this.eventListRange.isEventFilter() && this.eventListRange.isDateOutOfRange(datetime, "-")) continue;
                    MOut.G(this).println("--------------------------------------------------------------------");
                    MOut.G(this).print("Event:" + count);
                    MOut.G(this).print(" Time:" + datetime);
                    MOut.G(this).println(" SensorType:" + GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()));
                    if (this.parameters != null && this.parameters.length >= 1 && this.parameters[0].equals("-v")) {
                        System.out.println(item.toString());
                    }
                    if ((item.getSensorType() & 0xFF) >= 193 && (item.getSensorType() & 0xFF) <= 197 && (item.getEventType() & 0xFF) != 112) {
                        if (item.getEventData1() == -64 || item.getEventData1() == -63 || item.getEventData1() == -62 || item.getEventData1() == -61) {
                            MOut.G(this).print(GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()) + " " + (byte)(item.getSensorNumber() & 0xFF));
                        } else {
                            MOut.G(this).print(GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()));
                        }
                    } else {
                        Object sensorName = SDRRecord.sensorNumberToSensorName.get("" + (item.getSensorNumber() & 0xFF));
                        if (sensorName != null) {
                            MOut.G(this).print(sensorName.toString());
                        }
                    }
                    String reading = "";
                    if (item.getEventType() == 1) {
                        byte offset = item.getEventData1();
                        SDRRecord sdrRecord = (SDRRecord)SDRRecord.sensorNumberToSDRRecord.get("" + (item.getSensorNumber() & 0xFF));
                        if (sdrRecord != null) {
                            double readingValue = sdrRecord.calSensorReading(item.getEventData2() & 0xFF);
                            double threshold = sdrRecord.calSensorReading(item.getEventData3() & 0xFF);
                            if (item.getSensorType() == 4) {
                                reading = reading + "\nReading = " + (int)readingValue + " RPM, Threshold = " + (int)threshold + " RPM";
                            } else if (item.getSensorType() == 2) {
                                reading = reading + "\nReading = " + String.format("%3.2f", readingValue) + " V, Threshold = " + String.format("%3.2f", threshold) + " V";
                            } else if (item.getSensorType() == 1) {
                                reading = reading + "\nReading = " + String.format("%3.2f", readingValue) + " C, Threshold = " + String.format("%3.2f", threshold) + " C";
                            }
                        }
                    }
                    String desc = GlobalDefine.getEventType((byte)(item.getEventDir() | item.getEventType()), item.getSensorType(), item.getEventData1(), item.getEventData2(), item.getEventData3(), productID, item.getSensorNumber(), isMultipleCPU) + reading;
                    MOut.G(this).println("| Msg = " + desc);
                }
                if (this.eventListRange.isEventFilter() && count == 0) {
                    System.out.println("There are no event in last " + this.eventListRange.getDateUnit());
                }
            } else {
                MOut.G(this).println("SEL empty");
            }
            this.statusCode = 0;
        } else {
            RedfishHttpUtils utils = new RedfishHttpUtils();
            String url = "https://" + RedfishHttpUtils.getUrlIP(super.getConfig().getIp()) + "/redfish/v1/Systems/1/LogServices/Log1/Entries/";
            utils.sendRedfishGet(super.getConfig(), url);
            List<HashMap<String, String>> entryList = utils.getEntryList();
            if (entryList.size() == 0) {
                MOut.G(this).println("SEL empty");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (int index = 0; index < entryList.size(); ++index) {
                    String datetime = utils.convertDatetimeFormat(entryList.get(index).get("Created"));
                    if (this.eventListRange.isEventFilter() && this.eventListRange.isDateOutOfRange(datetime, "-")) continue;
                    String sensorType = entryList.get(index).get("OemSensorType");
                    if (sensorType == null || sensorType.isEmpty()) {
                        sensorType = Optional.ofNullable(entryList.get(index).get("SensorType")).orElse("");
                    }
                    stringBuilder.setLength(0);
                    stringBuilder.append("--------------------------------------------------------------------");
                    stringBuilder.append("\n");
                    stringBuilder.append("Event:");
                    stringBuilder.append(entryList.get(index).get("Id"));
                    stringBuilder.append(" Time:");
                    stringBuilder.append(datetime);
                    stringBuilder.append(" Severity:");
                    stringBuilder.append(entryList.get(index).get("Severity"));
                    stringBuilder.append(" SensorType:");
                    stringBuilder.append(sensorType);
                    stringBuilder.append("\n");
                    stringBuilder.append("| Msg = ");
                    stringBuilder.append(entryList.get(index).get("Message"));
                    stringBuilder.append(" - " + entryList.get(index).get("EntryCode"));
                    System.out.println(stringBuilder.toString());
                }
                if (this.eventListRange.isEventFilter() && stringBuilder.length() <= 0) {
                    System.out.println("There are no event in last " + this.eventListRange.getDateUnit());
                }
            }
            this.statusCode = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printFailMessage(int result, String responseString) {
        if (result >= 400 && result < 500) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode node = mapper.readTree(responseString);
                JsonNode error = node.path("error");
                JsonNode extendInfo = error.path("@Message.ExtendedInfo");
                if (!extendInfo.isArray()) return;
                for (JsonNode l : extendInfo) {
                    JsonNode messageArgs = l.path("MessageArgs");
                    if (!messageArgs.isArray()) continue;
                    for (JsonNode m : messageArgs) {
                        MOut.G(this).println("Error: " + m.asText());
                    }
                }
                return;
            }
            catch (JsonProcessingException e2) {
                e2.printStackTrace();
                return;
            }
        } else {
            MOut.G(this).println("...Failed upload file, completion code " + result);
        }
    }
}

