/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.SystemLockdownCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SELTimeCommand
extends SuperBladeCommand {
    String dateTimeString = null;
    public static final int YEAR_LOWER_BOUND = 2005;
    public static final int YEAR_UPPER_BOUND = 2037;

    @Override
    public boolean preValidate() {
        this.dateTimeString = null;
        if (this.parameters != null && this.parameters[0] != null) {
            this.dateTimeString = this.parameters[0];
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        SystemLockdownCommand systemLockdownCommand = new SystemLockdownCommand(null);
        systemLockdownCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        ipmiSELCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.dateTimeString == null) {
            String selTime = ipmiSELCommand.getSELTimeWithFormat();
            MOut.G(this).println(selTime);
            this.statusCode = 0;
        } else {
            if (systemLockdownCommand.isSystemLocked()) {
                MOut.G(this).println("System is in lock down mode. This action is forbidden.");
                this.statusCode = 156;
                return;
            }
            if (this.dateTimeString.length() != 12 && this.dateTimeString.length() != 14) {
                this.usage();
                this.statusCode = 147;
                return;
            }
            byte[] bdtAry = new byte[3];
            Date dt2 = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            sdf.setLenient(false);
            if (this.dateTimeString.length() == 12) {
                sdf.applyPattern("yyyyMMddHHmm");
            } else if (this.dateTimeString.length() == 14) {
                sdf.applyPattern("yyyyMMddHHmmss");
            }
            try {
                dt2 = sdf.parse(this.dateTimeString);
                int years = Integer.parseInt(this.dateTimeString.substring(0, 4));
                if (years < 2005 || 2037 < years) {
                    throw new ParseException("", 0);
                }
            }
            catch (ParseException e2) {
                this.invalidRange();
                this.statusCode = 147;
                return;
            }
            long timeValue = dt2.getTime();
            byte[] tempAry = new byte[4];
            ByteUtility.longTo4Bytes(tempAry, 0, timeValue /= 1000L);
            System.arraycopy(tempAry, 0, bdtAry, 0, bdtAry.length);
            boolean b2 = ipmiSELCommand.setSELTime(tempAry);
            if (b2) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Set SEL Time failed");
                this.statusCode = 149;
            }
        }
    }

    public void usage() {
        MOut.G(this).println("Date/Time format error.");
        MOut.G(this).println("");
        MOut.G(this).println("Format: YYYYMMDDhhmm    ex:201007161200   (2010/07/16 12:00)");
        MOut.G(this).println("Format: YYYYMMDDhhmmss  ex:20100716120030 (2010/07/16 12:30)");
    }

    private void invalidRange() {
        MOut.G(this).println("[Failed]: Date/Time is invalid.");
        MOut.G(this).println("Year:  2005 - 2037");
        MOut.G(this).println("Month: 1 - 12");
        MOut.G(this).println("Day:   1 - 31");
        MOut.G(this).println("Hour:  0 - 23");
        MOut.G(this).println("Min:   0 - 59");
        MOut.G(this).println("sec:   0 - 59");
    }

    public static void main(String[] args) {
        int eData2 = -1;
        int eData3 = -1;
        byte bank_high = (byte)((eData2 >> 4) + 64 + (eData3 & 3) * 4);
        byte bank_low = (byte)((eData2 & 0xF) + 39);
        System.out.println("" + ((eData2 >> 4) + 64));
        System.out.println("" + (eData3 & 3) * 4);
        System.out.println("bank_high =" + bank_high);
        System.out.println("bank_low =" + bank_low);
        String loc = String.format("@DIMM%c%c(CPU%x)", bank_high, bank_low, (eData3 & 3) + 1);
        System.out.println("loc =" + loc);
    }
}

