/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MOutFactory;
import com.supermicro.ipmi.text.ShellCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SMCIPMIToold {
    Map services;
    Set connections;
    int maxConnections;
    ThreadGroup threadGroup = new ThreadGroup(SMCIPMIToold.class.getName());
    Listener listener;
    PrintWriter logStream;
    Logger logger;
    Level logLevel;

    public static void main(String[] args) {
        MessageCenter.getInstance().deleteObservers();
        int port = 0;
        if (args.length >= 1) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        SMCIPMIToold s = new SMCIPMIToold(1000);
        try {
            s.addService(new SMCIPMIToolService(s, "mypassword"), port);
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            System.exit(99);
        }
    }

    public SMCIPMIToold(OutputStream logStream, int maxConnections) {
        this(maxConnections);
        this.setLogStream(logStream);
        this.log("Starting server");
    }

    public SMCIPMIToold(Logger logger, Level logLevel, int maxConnections) {
        this(maxConnections);
        this.setLogger(logger, logLevel);
        this.log("Starting server");
    }

    public SMCIPMIToold(int maxConnections) {
        this.maxConnections = maxConnections;
        this.services = new HashMap();
        this.connections = new HashSet(maxConnections);
    }

    public synchronized void setLogStream(OutputStream out) {
        this.logStream = out != null ? new PrintWriter(out) : null;
    }

    public synchronized void setLogger(Logger logger, Level level) {
        this.logger = logger;
        this.logLevel = level;
    }

    protected synchronized void log(String s) {
        if (this.logger != null) {
            this.logger.log(this.logLevel, s);
        }
        if (this.logStream != null) {
            this.logStream.println("[" + new Date() + "] " + s);
            this.logStream.flush();
        }
    }

    protected void log(Object o) {
        this.log(o.toString());
    }

    public synchronized void addService(Service service, int port) throws IOException {
        Integer key = new Integer(port);
        if (this.services.get(key) != null) {
            throw new IllegalArgumentException("Port " + port + " already in use.");
        }
        this.listener = new Listener(this.threadGroup, port, service);
        this.services.put(key, this.listener);
        this.log("Starting service " + service.getClass().getName() + " on port " + port);
        this.listener.start();
    }

    public synchronized void removeService(int port) {
        Integer key = new Integer(port);
        Listener listener = (Listener)this.services.get(key);
        if (listener == null) {
            return;
        }
        listener.pleaseStop();
        this.services.remove(key);
        this.log("Stopping service " + listener.service.getClass().getName() + " on port " + port);
    }

    protected synchronized void addConnection(Socket s, Service service) {
        if (this.connections.size() >= this.maxConnections) {
            try {
                PrintWriter out = new PrintWriter(s.getOutputStream());
                out.print("Connection refused; the server is busy; please try again later.\r\n");
                out.flush();
                s.close();
                this.log("Connection refused to " + s.getInetAddress().getHostAddress() + ":" + s.getPort() + ": max connections reached.");
            }
            catch (IOException e2) {
                this.log(e2);
            }
        } else {
            Connection c2 = new Connection(s, service);
            this.connections.add(c2);
            this.log("Connected to " + s.getInetAddress().getHostAddress() + ":" + s.getPort() + " on port " + s.getLocalPort() + " for service " + service.getClass().getName());
            c2.start();
        }
    }

    protected synchronized void endConnection(Connection c2) {
        this.connections.remove(c2);
        this.log("Connection to " + c2.client.getInetAddress().getHostAddress() + ":" + c2.client.getPort() + " closed.");
    }

    public synchronized void setMaxConnections(int max) {
        this.maxConnections = max;
    }

    public synchronized void displayStatus(PrintWriter out) {
        for (Integer port : this.services.keySet()) {
            Listener listener = (Listener)this.services.get(port);
            out.print("SERVICE " + listener.service.getClass().getName() + " ON PORT " + port + "\r\n");
        }
        out.print("MAX CONNECTIONS: " + this.maxConnections + "\r\n");
        for (Connection c2 : this.connections) {
            out.print("CONNECTED TO " + c2.client.getInetAddress().getHostAddress() + ":" + c2.client.getPort() + " ON PORT " + c2.client.getLocalPort() + " FOR SERVICE " + c2.service.getClass().getName() + "\r\n");
        }
    }

    public static interface Service {
        public void serve(InputStream var1, OutputStream var2) throws IOException;
    }

    public static class SMCIPMIToolService
    implements Service {
        SMCIPMIToold server;
        String password;

        public SMCIPMIToolService(SMCIPMIToold server, String password) {
            this.server = server;
            this.password = password;
        }

        @Override
        public void serve(InputStream i2, OutputStream o) throws IOException {
            ShellCommand shell = new ShellCommand();
            shell.newParser();
            IPMIInterfaceConfig config = new IPMIInterfaceConfig();
            config.setIp("127.0.0.1");
            config.setUserName("xxxxx");
            config.setPassword("xxxxx");
            shell.setConfig(config);
            MOut aMout = MOutFactory.createMOutInstanceWtihBufferOutput();
            MOut.addMOut(shell.getParser(), aMout);
            BufferedReader in = new BufferedReader(new InputStreamReader(i2));
            PrintWriter out = new PrintWriter(o);
            boolean authorized = true;
            while (true) {
                out.print(">");
                out.flush();
                String line = in.readLine();
                if (line == null || line.equals("$quit")) break;
                if (line.equals("$status")) {
                    this.server.displayStatus(out);
                    continue;
                }
                if (line.equals("$shutdown")) {
                    this.server.listener.pleaseStop();
                    break;
                }
                if (line.equals("$exit")) {
                    System.exit(0);
                    break;
                }
                if (!authorized) continue;
                try {
                    aMout.resetBuffer();
                    shell.processCommand(line);
                    out.print(aMout.getBufferContent());
                }
                catch (Exception e2) {
                    out.print(e2.getMessage());
                }
            }
            out.close();
            in.close();
            MOut.removeMOut(shell.getParser());
        }
    }

    public static class Control
    implements Service {
        SMCIPMIToold server;
        String password;
        boolean connected = false;

        public Control(SMCIPMIToold server, String password) {
            this.server = server;
            this.password = password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serve(InputStream i2, OutputStream o) throws IOException {
            BufferedReader in = new BufferedReader(new InputStreamReader(i2));
            PrintWriter out = new PrintWriter(o);
            boolean authorized = false;
            Control control = this;
            synchronized (control) {
                if (this.connected) {
                    out.print("ONLY ONE CONTROL CONNECTION ALLOWED.\r\n");
                    out.close();
                    return;
                }
                this.connected = true;
            }
            while (true) {
                out.print("> ");
                out.flush();
                String line = in.readLine();
                if (line == null) break;
                try {
                    StringTokenizer t = new StringTokenizer(line);
                    if (!t.hasMoreTokens()) continue;
                    String command = t.nextToken().toLowerCase();
                    if (command.equals("password")) {
                        String p = t.nextToken();
                        if (p.equals(this.password)) {
                            out.print("OK\r\n");
                            authorized = true;
                            continue;
                        }
                        out.print("INVALID PASSWORD\r\n");
                        continue;
                    }
                    if (command.equals("add")) {
                        Service service;
                        if (!authorized) {
                            out.print("PASSWORD REQUIRED\r\n");
                            continue;
                        }
                        String serviceName = t.nextToken();
                        Class<?> serviceClass = Class.forName(serviceName);
                        try {
                            service = (Service)serviceClass.newInstance();
                        }
                        catch (NoSuchMethodError e2) {
                            throw new IllegalArgumentException("Service must have a no-argument constructor");
                        }
                        int port = Integer.parseInt(t.nextToken());
                        this.server.addService(service, port);
                        out.print("SERVICE ADDED\r\n");
                        continue;
                    }
                    if (command.equals("remove")) {
                        if (!authorized) {
                            out.print("PASSWORD REQUIRED\r\n");
                            continue;
                        }
                        int port = Integer.parseInt(t.nextToken());
                        this.server.removeService(port);
                        out.print("SERVICE REMOVED\r\n");
                        continue;
                    }
                    if (command.equals("max")) {
                        if (!authorized) {
                            out.print("PASSWORD REQUIRED\r\n");
                            continue;
                        }
                        int max = Integer.parseInt(t.nextToken());
                        this.server.setMaxConnections(max);
                        out.print("MAX CONNECTIONS CHANGED\r\n");
                        continue;
                    }
                    if (command.equals("status")) {
                        if (!authorized) {
                            out.print("PASSWORD REQUIRED\r\n");
                            continue;
                        }
                        this.server.displayStatus(out);
                        continue;
                    }
                    if (command.equals("help")) {
                        out.print("COMMANDS:\r\n\tpassword <password>\r\n\tadd <service> <port>\r\n\tremove <port>\r\n\tmax <max-connections>\r\n\tstatus\r\n\thelp\r\n\tquit\r\n");
                        continue;
                    }
                    if (command.equals("quit")) break;
                    out.print("UNRECOGNIZED COMMAND\r\n");
                }
                catch (Exception e3) {
                    out.print("ERROR WHILE PARSING OR EXECUTING COMMAND:\r\n" + e3 + "\r\n");
                }
            }
            control = this;
            synchronized (control) {
                this.connected = false;
            }
            out.close();
            in.close();
        }
    }

    public static class Time
    implements Service {
        @Override
        public void serve(InputStream i2, OutputStream o) throws IOException {
            PrintWriter out = new PrintWriter(o);
            out.print(new Date() + "\r\n");
            out.close();
            i2.close();
        }
    }

    public class Connection
    extends Thread {
        Socket client;
        Service service;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connection(Socket client, Service service) {
            super("Server.Connection:" + client.getInetAddress().getHostAddress() + ":" + client.getPort());
            Connection connection = this;
            synchronized (connection) {
                this.client = client;
                this.service = service;
            }
        }

        @Override
        public synchronized void run() {
            try {
                InputStream in = this.client.getInputStream();
                OutputStream out = this.client.getOutputStream();
                this.service.serve(in, out);
            }
            catch (IOException e2) {
                SMCIPMIToold.this.log(e2);
            }
            finally {
                SMCIPMIToold.this.endConnection(this);
            }
        }
    }

    public class Listener
    extends Thread {
        ServerSocket listen_socket;
        int port;
        Service service;
        volatile boolean stop;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Listener(ThreadGroup group, int port, Service service) throws IOException {
            super(group, "Listener:" + port);
            this.stop = false;
            this.listen_socket = new ServerSocket(port);
            int actualPort = this.listen_socket.getLocalPort();
            System.out.println("Server start at port :" + actualPort);
            this.listen_socket.setSoTimeout(5000);
            this.port = port;
            Listener listener = this;
            synchronized (listener) {
                this.service = service;
            }
        }

        public synchronized void pleaseStop() {
            this.stop = true;
            this.interrupt();
            try {
                this.listen_socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                try {
                    Socket client = this.listen_socket.accept();
                    Listener listener = this;
                    synchronized (listener) {
                        SMCIPMIToold.this.addConnection(client, this.service);
                    }
                }
                catch (InterruptedIOException client) {
                }
                catch (IOException e2) {
                    SMCIPMIToold.this.log(e2);
                }
            }
        }
    }
}

