/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MultiInteger;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class SuperBladeMultiCommand
extends Command {
    int[] indexes;
    String[] indexMicroBlade;
    Command singleCommand;
    int type;

    private void processIndexes() {
        this.preParameters.remove(0);
        String multiInt = (String)this.preParameters.get(1);
        switch (MultiInteger.validateInteger(multiInt)) {
            case 0: {
                this.indexes = new int[1];
                this.indexes[0] = Integer.parseInt(multiInt);
                this.type = 0;
                break;
            }
            case 2: {
                this.indexes = MultiInteger.parseMultiInteger(multiInt);
                this.type = 2;
                break;
            }
            case 1: {
                this.processStar();
                this.type = 1;
                break;
            }
        }
    }

    private void processIndexMicroblade() {
        this.preParameters.remove(0);
        String multiIndex = (String)this.preParameters.get(1);
        if (multiIndex.contains("*")) {
            this.indexMicroBlade = new String[28];
            for (int i2 = 1; i2 <= 14; ++i2) {
                this.indexMicroBlade[i2 - 1] = "A" + i2;
                this.indexMicroBlade[13 + i2] = "B" + i2;
            }
        } else if (multiIndex.contains(",")) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(multiIndex, ",");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            this.indexMicroBlade = new String[list.size()];
            for (int i3 = 0; i3 < list.size(); ++i3) {
                this.indexMicroBlade[i3] = (String)list.get(i3);
            }
        } else {
            this.indexMicroBlade = new String[1];
            this.indexMicroBlade[0] = (String)this.preParameters.get(1);
        }
    }

    public abstract void processStar();

    public void helpGenIntArray(int size) {
        this.indexes = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            this.indexes[i2] = i2 + 1;
        }
    }

    public boolean preValidate() {
        return true;
    }

    @Override
    public void execute() {
        int i2;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
            this.processIndexMicroblade();
            if (this.indexMicroBlade == null || this.indexMicroBlade.length == 0) {
                return;
            }
            if (!this.preValidate()) {
                this.statusCode = 147;
                return;
            }
            try {
                for (i2 = 0; i2 < this.indexMicroBlade.length; ++i2) {
                    this.preParameters.remove(1);
                    this.preParameters.add(1, "" + this.indexMicroBlade[i2]);
                    this.singleCommand.setConfig(this.config);
                    this.singleCommand.setPreParameters(this.preParameters);
                    this.singleCommand.setParameters(this.parameters);
                    if (this.indexMicroBlade.length != 1) {
                        MOut.G(this).printf("[%s]:\n", this.indexMicroBlade[i2]);
                    }
                    this.singleCommand.execute();
                    this.statusCode = this.singleCommand.statusCode;
                }
            }
            catch (Exception ex) {
                MOut.G(this).println(ex.getMessage());
                this.statusCode = 148;
            }
        }
        this.processIndexes();
        if (this.indexes == null || this.indexes.length == 0) {
            return;
        }
        if (!this.preValidate()) {
            this.statusCode = 147;
            return;
        }
        try {
            for (i2 = 0; i2 < this.indexes.length; ++i2) {
                this.preParameters.remove(1);
                this.preParameters.add(1, "" + this.indexes[i2]);
                this.singleCommand.setConfig(this.config);
                this.singleCommand.setPreParameters(this.preParameters);
                this.singleCommand.setParameters(this.parameters);
                if (this.indexes.length != 1) {
                    MOut.G(this).printf("[%2d]:\n", this.indexes[i2]);
                }
                this.singleCommand.execute();
                this.statusCode = this.singleCommand.statusCode;
            }
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

