/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.MB_B10DRG_SensorEntity;
import com.supermicro.ipmi.blade.MB_B10DRI_SensorEntity;
import com.supermicro.ipmi.blade.MB_B10DRT_SensorEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class SuperBladePowerConsumptionCommand
extends SuperBladeCommand {
    public SuperBladePowerConsumptionCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public void runCommand() throws Exception {
        StringBuffer sb = new StringBuffer();
        String formatTemplate = "  %-15s | %22s |\n";
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.setIsQueryMBSensorEntity(true);
        bladeSystem.setIsQueryPowerSupplyEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        sb.append(String.format(formatTemplate, "Module", "Power Consumption (W)"));
        sb.append(String.format(formatTemplate, "------", "---------------------"));
        for (int i2 = 0; i2 < bladeSystem.getBlades().length; ++i2) {
            int powerWatt;
            MB_B10DRI_SensorEntity sensor;
            BladeEntity b2 = bladeSystem.getBlades()[i2];
            if (b2.getPresent() <= 0) continue;
            if (b2.getMBModel() == 29 || b2.getMBModel() == 34 || b2.getMBModel() == 27 || b2.getMBModel() == 33) {
                sensor = (MB_B10DRI_SensorEntity)bladeSystem.getMbSensors()[i2];
                powerWatt = sensor.getPwr();
                sb.append(String.format(formatTemplate, "Blade " + b2.getModuleIndex(), powerWatt));
                continue;
            }
            if (b2.getMBModel() == 30 || b2.getMBModel() == 31 || b2.getMBModel() == 32) {
                sensor = (MB_B10DRT_SensorEntity)bladeSystem.getMbSensors()[i2];
                powerWatt = sensor.getPwr();
                sb.append(String.format(formatTemplate, "Blade " + b2.getModuleIndex(), powerWatt));
                continue;
            }
            if (b2.getMBModel() == 35 || b2.getMBModel() == 36 || b2.getMBModel() == 37) {
                sensor = (MB_B10DRG_SensorEntity)bladeSystem.getMbSensors()[i2];
                powerWatt = sensor.getPwr();
                sb.append(String.format(formatTemplate, "Blade " + b2.getModuleIndex(), powerWatt));
                continue;
            }
            sb.append(String.format(formatTemplate, "Blade " + b2.getModuleIndex(), "No support"));
        }
        sb.append("\n");
        sb.append(String.format(formatTemplate, "Module", "Power Consumption (W)"));
        sb.append(String.format(formatTemplate, "------", "---------------------"));
        int sum = 0;
        for (int i3 = 0; i3 < bladeSystem.getPowerSupplies().length; ++i3) {
            PowerSupplyEntity p = bladeSystem.getPowerSupplies()[i3];
            int pc = (int)(p.getAcInputVolt() * p.getAcRMSCurrentFormula());
            if (p.getPresent() > 0) {
                sb.append(String.format(formatTemplate, "PS " + p.getModuleIndex(), pc));
            }
            sum += pc;
        }
        sb.append(String.format(formatTemplate, "", ""));
        sb.append(String.format(formatTemplate, "Total", sum));
        MOut.G(this).print(sb.toString());
        this.statusCode = 0;
    }
}

