/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.CommandIncompleteException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.Parser;
import com.supermicro.ipmi.text.UserAccountHelper;
import com.supermicro.ipmi.text.UserInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuperBladeTool {
    public static String version = "2.28.0";
    public static String buildNo = "240703";
    public static String companyName = "Super Micro Computer, Inc.";
    public static String softwareName = "SMCIPMITool";
    public static String softwareInfo;
    public static final boolean DEBUG = false;

    public SuperBladeTool() {
        String prefixInfo = "SMC IPMI Tool";
        String middleInfo = " V" + version + "(Build " + buildNo + ")";
        String suffixInfo = " - " + companyName;
        if (GlobalDefine.INTERNAL_VERSION) {
            middleInfo = " V" + version + "(Build " + buildNo + "_Production)";
        } else if (GlobalDefine.SCC_CHECKING_TOOL) {
            String checkingToolVersion = "1.0.1";
            prefixInfo = "SCCInspector";
            middleInfo = " V" + checkingToolVersion + "(Build " + buildNo + ")";
        } else if (GlobalDefine.COMPUWARE_PROJECT) {
            softwareName = "CPWIPMITool";
            companyName = "Compuware Technology Inc.";
            prefixInfo = "CPW IPMI Tool";
            suffixInfo = System.lineSeparator() + "Copyright (C) 2004-2024 Compuware" + System.lineSeparator() + "Technology Inc. All rights reserved.";
        } else if (GlobalDefine.INTEL_PROJECT) {
            middleInfo = " V" + version + "(Build " + buildNo + "_INTEL_OEM)";
        }
        softwareInfo = prefixInfo + middleInfo + suffixInfo;
    }

    public static void main(String[] args) {
        SuperBladeTool.disableAccessWarnings();
        SuperBladeTool smcIPMITool = new SuperBladeTool();
        int status = smcIPMITool.execute(args);
        System.exit(status);
    }

    public int execute(String[] args) {
        int i2;
        SuperBladeTool.setMiscOption();
        try {
            SuperBladeTool.addDir(".");
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
        String ip = "";
        String username = null;
        String password = null;
        Parser parser = new Parser();
        String[] subArgs = null;
        String commandString = null;
        String fileName = null;
        UserInfo userInfo = null;
        boolean isStandardCLIMode = false;
        if (args.length > 0) {
            for (i2 = 0; i2 < args.length; ++i2) {
                if (!"-filemode".equalsIgnoreCase(args[i2])) continue;
                isStandardCLIMode = true;
                if (i2 == args.length - 1) {
                    this.standardCLIUsage();
                    return 182;
                }
                fileName = args[i2 + 1];
                if (fileName == null) continue;
                File file = new File(fileName.trim());
                if (!file.exists()) {
                    MOut.G().println("File not found !");
                    return 182;
                }
                userInfo = SuperBladeTool.setSecret(file);
                username = userInfo.getUsername();
                password = userInfo.getPassword();
            }
        }
        if (isStandardCLIMode) {
            for (i2 = 0; i2 < args.length - 1; ++i2) {
                if ("-i".equals(args[i2].trim())) {
                    ip = args[i2 + 1].trim();
                    continue;
                }
                if (!"-c".equals(args[i2].trim())) continue;
                commandString = args[i2 + 1].trim();
                subArgs = commandString.split("\\s+");
            }
            boolean isShowUsage = false;
            if ("".equals(ip)) {
                MOut.G().println("IP not found");
                isShowUsage = true;
            } else if ("-c".equals(ip) || "-f".equals(ip)) {
                MOut.G().println("Please fill IP");
                isShowUsage = true;
            } else if (username == null || password == null || "".equals(username) || "".equals(password)) {
                MOut.G().println("Please use -f <file> to set up username/password");
                isShowUsage = true;
            } else if (commandString == null || "".equals(commandString)) {
                MOut.G().println("Command can't be empty");
                isShowUsage = true;
            } else if ("-i".equals(commandString) || "-f".equals(commandString)) {
                MOut.G().println("Command can't be empty");
                isShowUsage = true;
            }
            if (isShowUsage) {
                this.standardCLIUsage();
                return 182;
            }
        } else {
            if (args.length < 3) {
                SuperBladeTool.usage();
                return 182;
            }
            ip = args[0];
            username = args[1];
            password = args[2];
            subArgs = new String[args.length - 3];
            System.arraycopy(args, 3, subArgs, 0, subArgs.length);
        }
        if (!SuperBladeTool.validateIP(ip) && !SuperBladeTool.validateIPv6(ip)) {
            try {
                InetAddress giriAddress = InetAddress.getByName(ip);
                ip = giriAddress.getHostAddress();
            }
            catch (UnknownHostException e2) {
                MOut.G().println("IP or Domain name error !");
                return 181;
            }
        }
        if (username.length() > UserAccountHelper.USERNANE_LENGTH_MAX) {
            MOut.G().println("Username cannot more than " + UserAccountHelper.USERNANE_LENGTH_MAX + " characters");
            return 182;
        }
        if (password.length() > UserAccountHelper.PASSWORD_LENGTH_MAX) {
            MOut.G().println("Password cannot more than " + UserAccountHelper.PASSWORD_LENGTH_MAX + " characters");
            return 182;
        }
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        SuperBladeTool.setSMCRAKP(ip, config);
        SuperBladeTool.setCipherSuite(config);
        Command command = null;
        try {
            command = parser.parse(parser.argumentRoot, subArgs);
        }
        catch (CommandIncompleteException e3) {
            return 0;
        }
        if (command == null) {
            return 180;
        }
        command.setConfig(config);
        command.setOriginalParser(parser);
        try {
            command.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return command.getStatusCode();
    }

    public static void usage() {
        MOut.G().println("");
        MOut.G().println(softwareInfo);
        MOut.G().println("Usage:");
        MOut.G().println("      " + softwareName + " <IP> <username> <password> [commands ... ]");
    }

    public static void ver() {
        MOut.G().println(softwareInfo);
    }

    public static boolean validateIP(String ip) {
        Pattern macPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher m = macPattern.matcher(ip);
        return m.matches();
    }

    public static boolean validateIPv6(String inet6Address) {
        boolean containsCompressedZeroes;
        boolean bl = containsCompressedZeroes = inet6Address.indexOf("::") > -1;
        if (containsCompressedZeroes && inet6Address.indexOf("::") != inet6Address.lastIndexOf("::")) {
            return false;
        }
        if (inet6Address.startsWith(":") && !inet6Address.startsWith("::") || inet6Address.endsWith(":") && !inet6Address.endsWith("::")) {
            return false;
        }
        Object[] octets = inet6Address.split(":");
        if (containsCompressedZeroes) {
            ArrayList<String> octetList = new ArrayList<String>(Arrays.asList(octets));
            if (inet6Address.endsWith("::")) {
                octetList.add("");
            } else if (inet6Address.startsWith("::") && !octetList.isEmpty()) {
                octetList.remove(0);
            }
            octets = octetList.toArray();
        }
        if (octets.length > 8) {
            return false;
        }
        int validOctets = 0;
        int emptyOctets = 0;
        for (int index = 0; index < octets.length; ++index) {
            String octet = octets[index];
            if (octet.length() == 0) {
                if (++emptyOctets > 1) {
                    return false;
                }
            } else {
                emptyOctets = 0;
                if (octet.indexOf(".") > -1) {
                    if (!inet6Address.endsWith(octet)) {
                        return false;
                    }
                    if (index > octets.length - 1 || index > 6) {
                        return false;
                    }
                    if (!SuperBladeTool.validateIP(octet)) {
                        return false;
                    }
                    validOctets += 2;
                    continue;
                }
                if (octet.length() > 4) {
                    return false;
                }
                int octetInt = 0;
                try {
                    octetInt = Integer.valueOf(octet, 16);
                }
                catch (NumberFormatException e2) {
                    return false;
                }
                if (octetInt < 0 || octetInt > 65535) {
                    return false;
                }
            }
            ++validOctets;
        }
        return validOctets >= 8 || containsCompressedZeroes;
    }

    public static void addDir(String s) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            for (int i2 = 0; i2 < paths.length; ++i2) {
                if (!s.equals(paths[i2])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = s;
            field.set(null, tmp);
        }
        catch (IllegalAccessException e2) {
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e3) {
            throw new IOException("Failed to get field handle to set library path");
        }
    }

    public static void setMiscOption() {
        String oemRAKP;
        ConfigAccessor ca = new ConfigAccessor(".", softwareName + ".properties");
        int debug_level = 0;
        try {
            debug_level = Integer.parseInt(ca.getProperty("debug_level"));
        }
        catch (NumberFormatException ex) {
            debug_level = 0;
        }
        GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = debug_level;
        String debug = ca.getProperty("debug_trace");
        if ("on".equals(debug)) {
            GlobalDefine.DEBUG_TRACE = true;
        }
        if ("on".equals(oemRAKP = ca.getProperty("oem_rakp"))) {
            GlobalDefine.OEM_RAKP_FLAG = true;
        }
    }

    public static void setSMCRAKP(String ip, IPMIInterfaceConfig config) {
        ConfigAccessor ca = new ConfigAccessor(".", softwareName + ".properties");
        String oemRAKP = ca.getProperty("oem_rakp");
        if ("on".equals(oemRAKP)) {
            return;
        }
        ConfigAccessor rakp = new ConfigAccessor(".", "smcrakp.properties");
        String rakpOfIP = rakp.getProperty(ip);
        GlobalDefine.OEM_RAKP_FLAG = "on".equals(rakpOfIP);
    }

    public static void setCipherSuite(IPMIInterfaceConfig config) {
        ConfigAccessor ca = new ConfigAccessor(".", softwareName + ".properties");
        int cipher = 3;
        try {
            cipher = Integer.parseInt(ca.getProperty("cipher_suite"));
            config.setCipherSuiteID((byte)cipher);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static UserInfo setSecret(File file) {
        ConfigAccessor ca = new ConfigAccessor(file.getAbsoluteFile().getParent(), file.getName());
        String username = "";
        String password = "";
        try {
            username = ca.getProperty("username");
            password = ca.getProperty("password");
            UserInfo userInfo = new UserInfo();
            userInfo.setUsername(username);
            userInfo.setPassword(password);
            return userInfo;
        }
        catch (Exception ex) {
            MOut.G().println("Username or password not found in " + file.getName());
            return null;
        }
    }

    public static void disableAccessWarnings() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
            putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void standardCLIUsage() {
        String format = "%-20s %-8s";
        MOut.G().println("Usage:");
        MOut.G().println(softwareName + " -filemode <file> -i <ip> -f  -c <\"commands ...\">");
        MOut.G().println(String.format(format, " -c <command>", "Operation command, ex: -c \"ipmi power status\""));
        MOut.G().println(String.format(format, " -i <ip>", "BMC IP"));
        MOut.G().println(String.format(format, " -filemode <file>", "Read username and password from file"));
        MOut.G().println(String.format(format, "", "ex: file.txt"));
        MOut.G().println(String.format(format, "", "--------------"));
        MOut.G().println(String.format(format, "", "username=ADMIN"));
        MOut.G().println(String.format(format, "", "password=ADMIN"));
    }
}

