/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMITwinProCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class TPConfigIDCommand
extends SuperBladeCommand {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runCommand() throws Exception {
        IPMITwinProCommand ipmiTwinProCommand = new IPMITwinProCommand(null);
        ipmiTwinProCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            if (!ipmiTwinProCommand.isSupportTwinProCommand()) {
                this.statusCode = 153;
                MOut.G(this).println("Not supported device");
                return;
            }
        }
        catch (Exception e2) {
            this.statusCode = 153;
            MOut.G(this).println("Cannot get MCU Info");
            return;
        }
        if (this.parameters != null && this.parameters.length == 1) {
            int configID;
            String data = this.parameters[0];
            if (data.startsWith("0x")) {
                char[] charArray = data.toCharArray();
                if (charArray.length == 3) {
                    String value = "" + charArray[2];
                    configID = Integer.parseInt(value, 16);
                } else {
                    if (charArray.length != 4) {
                        MOut.G(this).println("Out of Range");
                        this.statusCode = 147;
                        return;
                    }
                    String value = "" + charArray[2] + charArray[3];
                    configID = Integer.parseInt(value, 16);
                }
            } else {
                try {
                    configID = Integer.parseInt(data);
                }
                catch (NumberFormatException e3) {
                    MOut.G(this).println("Out of Range");
                    this.statusCode = 147;
                    return;
                }
            }
            try {
                ipmiTwinProCommand.setConfigID(configID);
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            catch (Exception e4) {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                return;
            }
        }
        byte[] bytes = ipmiTwinProCommand.getNodeSize();
        if (bytes == null) {
            MOut.G(this).println("Failed");
            this.statusCode = 149;
            return;
        }
        String configIDStr = bytes[0] == 33 || bytes[0] == 65 ? ByteUtility.byteToHex(bytes[0]) : Integer.toString(bytes[0]);
        MOut.G(this).println("ConfigID: " + configIDStr);
        this.statusCode = 0;
    }
}

