/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MOutFactory;
import com.supermicro.ipmi.text.ShellCommand;
import java.io.File;
import java.io.IOException;

public class ToLogCommand
extends Command {
    ShellCommand shell = null;
    String filename;
    int option;
    String commands;

    @Override
    public void execute() {
        boolean result = this.preValidate();
        if (!result) {
            this.statusCode = 147;
            return;
        }
        File file = new File(this.filename);
        File path = file.getParentFile();
        if (!path.exists()) {
            path.mkdirs();
        }
        this.shell = new ShellCommand();
        this.shell.newParser();
        this.shell.setConfig(this.getConfig());
        MOut aMout = MOutFactory.createMOutInstanceWtihBufferOutput();
        MOut.addMOut(this.shell.getParser(), aMout);
        this.shell.processCommand(this.commands);
        try {
            switch (this.option) {
                case 0: {
                    aMout.bufferToFile(this.filename);
                    break;
                }
                case 1: {
                    aMout.bufferAppendFile(this.filename);
                }
            }
            this.statusCode = 0;
            MOut.G(this).println("Write to " + this.filename + " Done");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            this.statusCode = 148;
        }
        MOut.removeMOut(this.shell.getParser());
    }

    private boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 3) {
            this.usage();
            return false;
        }
        String optionString = this.parameters[0];
        if (optionString.equalsIgnoreCase("n")) {
            this.option = 0;
        } else if (optionString.equalsIgnoreCase("a")) {
            this.option = 1;
        } else {
            this.usage();
            return false;
        }
        this.filename = this.parameters[1];
        this.commands = "";
        for (int i2 = 2; i2 < this.parameters.length; ++i2) {
            this.commands = this.commands + " " + this.parameters[i2];
        }
        return true;
    }

    public void usage() {
        MOut.G(this).println("Usage: toLog <option> <filename> <commands...>");
        MOut.G(this).println("       option");
        MOut.G(this).println("        n: new to file");
        MOut.G(this).println("        a: append to file");
    }

    public static void main(String[] args) throws Exception {
        File file = new File("c:\\x1\\x2\\x3\\x4\\x5.txt");
        System.out.println(file.getAbsolutePath());
        System.out.println(file.getCanonicalPath());
        System.out.println(file.getPath());
        System.out.println(file.getParent());
        System.out.println(new File(file.getParent()).mkdirs());
        file.mkdirs();
    }
}

