/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.text.UserAccountHelper;
import java.util.HashMap;
import java.util.List;

public class UserListCommand
extends SuperBladeCommand {
    private int userID;

    @Override
    public boolean preValidate() {
        if (super.getParameters() != null) {
            try {
                this.userID = Integer.valueOf(super.getParameters()[0]);
                if (this.userID <= UserAccountHelper.USER_ID_BEGIN || this.userID > UserAccountHelper.USER_ID_END) {
                    MOut.G(this).println("user id is out of range");
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println("Invalid parameter");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (super.getParameters() == null) {
            boolean isAccountTypeSupported;
            int numberOfAvailableUser = ipmiMessagingCommand.getNumberOfAvailableUser();
            int countOfCurrentEnabledUser = ipmiMessagingCommand.getCountOfCurrentEnabledUser();
            boolean bl = isAccountTypeSupported = !IPMIMessagingCommand.isBeforeX12(ipmiMessagingCommand.getSystemGUID());
            if (numberOfAvailableUser == -2 || countOfCurrentEnabledUser == -2) {
                MOut.G(this).println("Can not execute command due to insufficient privilege level or other security based restriction");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Maximum number of Users          : " + numberOfAvailableUser);
            MOut.G(this).println("Count of currently enabled Users : " + countOfCurrentEnabledUser);
            String formatTemplate = "%8s | %-15s | %-18s | %-8s " + (isAccountTypeSupported ? "| %-18s " : "") + "\n";
            MOut.G(this).printf(formatTemplate, "User ID", "User Name", "Privilege Level", "Enable", isAccountTypeSupported ? "Account Types" : "");
            MOut.G(this).printf(formatTemplate, "-------", "-----------", "---------------", "------", isAccountTypeSupported ? "------------" : "");
            for (int i2 = 2; i2 <= numberOfAvailableUser; ++i2) {
                String name = ipmiMessagingCommand.getUserNameByID((byte)i2);
                if (name == null || name.length() == 0) continue;
                byte privilege = ipmiMessagingCommand.getUserPrivilegeByID((byte)i2);
                if (this.config.getPrivilege() < privilege && privilege != 15) continue;
                boolean isEnabled = ipmiMessagingCommand.isEnableUser((byte)i2);
                String accountTypeInfo = isAccountTypeSupported ? this.getAccountTypes(super.getConfig(), i2) : "";
                MOut.G(this).printf(formatTemplate, "" + i2, name, this.getPriviledgeString(privilege), isEnabled ? "Yes" : "No", accountTypeInfo);
            }
            this.statusCode = 0;
        } else {
            this.printAccountInfo(ipmiMessagingCommand, this.userID);
        }
    }

    private String getPriviledgeString(int p) {
        switch (p) {
            case 4: {
                return "Administrator";
            }
            case 3: {
                return "Operator";
            }
            case 2: {
                return "User";
            }
            case 1: {
                return "Callback";
            }
            case 15: {
                return "No Access";
            }
        }
        return "";
    }

    private String getAccountTypes(IPMIInterfaceConfig config, int id) {
        StringBuilder strBuilder = new StringBuilder();
        UserAccountHelper helper = new UserAccountHelper();
        List<String> types = helper.getAccountTypes(config, id);
        if (types != null) {
            for (int index = 0; index < types.size(); ++index) {
                strBuilder.append((index > 0 ? "," : "") + types.get(index));
                if (!types.get(index).equalsIgnoreCase("Redfish")) continue;
                strBuilder.append("/IPMI");
            }
            return strBuilder.toString();
        }
        return "";
    }

    private boolean printAccountInfo(IPMIMessagingCommand command, int id) {
        int numberOfAvailableUser = command.getNumberOfAvailableUser();
        if (id > numberOfAvailableUser) {
            MOut.G(this).println("User id is out of range");
            MOut.G(this).println("Maximum number of Users : " + numberOfAvailableUser);
            return false;
        }
        byte userPrivilege = command.getUserPrivilegeByID((byte)id);
        if (userPrivilege == 0) {
            MOut.G(this).println("User id does not exist");
            return false;
        }
        if (userPrivilege > super.getConfig().getPrivilege() && userPrivilege != 15) {
            MOut.G(this).println("Insufficient privilege");
            return false;
        }
        String formatTemplate = "%-25s : %-40s";
        MOut.G(this).println("User Information");
        MOut.G(this).println("-------------------------------------------");
        MOut.G(this).println(String.format(formatTemplate, "User ID", String.valueOf(id)));
        MOut.G(this).println(String.format(formatTemplate, "User Name", command.getUserNameByID((byte)id)));
        MOut.G(this).println(String.format(formatTemplate, "Privilege Level", this.getPriviledgeString(userPrivilege)));
        MOut.G(this).println(String.format(formatTemplate, "Enable", command.isEnableUser((byte)id) ? "Yes" : "No"));
        if (!IPMIMessagingCommand.isBeforeX12(command.getSystemGUID())) {
            String types;
            MOut.G(this).println(String.format(formatTemplate, "Account Types", this.getAccountTypes(super.getConfig(), id)));
            UserAccountHelper helper = new UserAccountHelper();
            HashMap<String, String> map = helper.getAccountInfo(super.getConfig(), id);
            if (map != null && (types = map.get("AccountTypes")) != null && types.contains("SNMP")) {
                String authProtocol = map.get("SNMP/AuthenticationProtocol");
                String privProtocol = map.get("SNMP/EncryptionProtocol");
                MOut.G(this).println(String.format(formatTemplate, "Auth Protocol", authProtocol));
                MOut.G(this).println(String.format(formatTemplate, "Private Protocol", privProtocol));
            }
        }
        return true;
    }
}

