/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class VMISOCommand
extends SuperBladeCommand {
    byte driveID;
    String hostIP;
    String shareName;
    String imageName;
    String username;
    String password;

    public VMISOCommand() {
        super.setMasterCheckingRequired(true);
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public boolean preValidate() {
        String usage = "Usage: vm iso <drive ID> <host IP> <share name> <path to image> [username] [password]\ndrive ID = <1|2>\nPlease make sure the drive is empty";
        if (this.parameters == null || this.parameters.length < 4 || this.parameters.length > 6) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.driveID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("drive ID should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.driveID < 1 || this.driveID > 2) {
            MOut.G(this).println("Invalid drive number");
            MOut.G(this).println(usage);
            return false;
        }
        this.hostIP = this.parameters[1];
        if (!IPMILanCommand.isIPAddress(this.hostIP)) {
            MOut.G(this).println("host IP is not valid");
            return false;
        }
        this.shareName = this.parameters[2];
        this.imageName = this.parameters[3];
        if (this.parameters.length > 4) {
            this.username = this.parameters[4];
        }
        if (this.parameters.length > 5) {
            this.password = this.parameters[5];
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isVirutalMediaSupported()) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ipmiOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiOEMCommand.checkNoVMAndWeb()) {
            MOut.G(this).println("This device doesn't support virtual media");
            this.statusCode = 153;
            return;
        }
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        ipmiRaritanOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean b2 = ipmiRaritanOEMCommand.mountISOImageForTextMode(this.driveID, this.hostIP, this.shareName, this.imageName, this.username, this.password);
        if (b2) {
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Failed");
            this.statusCode = 149;
        }
    }
}

